% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLot_bias_and_variance_of_an_estimate.r
\name{Plot_vb}
\alias{Plot_vb}
\title{A function to plot variance- and bias dependencies on n. Works in conjunction with \code{\link{CLT}} function.}
\usage{
Plot_vb(data)
}
\arguments{
\item{data}{bias/variance data frame produced by CLT}
}
\value{
The function returns a ggplot graph.
}
\description{
A function to plot variance- and bias dependencies on n. Works in conjunction with \code{\link{CLT}} function.
}
\examples{

# Light weight computaions

m<-25; M<-50
alpha<-1.8; H<-0.8; sigma<-0.3
S<-c(1:3)*1e2
p<-.4; p_prime<-.2; t1<-1; t2<-2
k<-2; NmonteC<-50

# Here is the continuous H-1/alpha inference procedure
theor_3_1_H_clt<-CLT(s=S,fr='H',Nmc=NmonteC,
                     m=m,M=M,alpha=alpha,H=H,
                     sigma=sigma,ContinEstim,
                     t1=t1,t2=t2,p=p,k=k)
Plot_vb(theor_3_1_H_clt$BSdM)

\donttest{
# More demanding example (it is better to use multicore setup)
# General low frequency inference

m<-45; M<-60
alpha<-0.8; H<-0.8; sigma<-0.3
S<-c(1:15)*1e2
p<-.4; t1<-1; t2<-2
NmonteC<-50

# Here is the continuous H-1/alpha inference procedure
theor_4_1_H_clt<-CLT(s=S,fr='H',Nmc=NmonteC,
                     m=m,M=M,alpha=alpha,H=H,
                     sigma=sigma,GenLowEstim,
                     t1=t1,t2=t2,p=p)
Plot_vb(theor_4_1_H_clt$BSdM)
}

}
\seealso{
\code{\link{Plot_dens}}
}
