% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{print.NuggetKriging}
\alias{print.NuggetKriging}
\title{Print the content of a \code{NuggetKriging} object.}
\usage{
\method{print}{NuggetKriging}(x, ...)
}
\arguments{
\item{x}{A (S3) \code{NuggetKriging} Object.}

\item{...}{Ignored.}
}
\value{
String of printed object.
}
\description{
Print the content of a \code{NuggetKriging} object.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))

k <- NuggetKriging(y, X, "matern3_2")

print(k)
## same thing
k
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
