% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{normalize}
\alias{normalize}
\title{Normalize raw datasets to column sums}
\usage{
normalize(object, chunk = 1000, format.type = "10X", verbose = TRUE)
}
\arguments{
\item{object}{\code{liger} object.}

\item{chunk}{size of chunks in hdf5 file. (default 1000)}

\item{format.type}{string of HDF5 format (10X CellRanger by default).}

\item{verbose}{Print progress bar/messages (TRUE by default)}
}
\value{
\code{liger} object with norm.data slot set.
}
\description{
This function normalizes data to account for total gene expression across a cell.
}
\examples{
# Demonstration using matrices with randomly generated numbers
Y <- matrix(runif(5000,0,2), 10,500)
Z <- matrix(runif(5000,0,2), 10,500)
ligerex <- createLiger(list(y_set = Y, z_set = Z))
ligerex <- normalize(ligerex)
}
