% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{plotGeneLoadings}
\alias{plotGeneLoadings}
\title{Generate t-SNE plots and gene loading plots}
\usage{
plotGeneLoadings(
  object,
  dataset1 = NULL,
  dataset2 = NULL,
  num.genes.show = 12,
  num.genes = 30,
  mark.top.genes = TRUE,
  factor.share.thresh = 10,
  log.fc.thresh = 1,
  umi.thresh = 30,
  frac.thresh = 0,
  pval.thresh = 0.05,
  do.spec.plot = TRUE,
  max.val = 0.1,
  pt.size = 0.4,
  option = "plasma",
  zero.color = "#F5F5F5",
  return.plots = FALSE,
  axis.labels = NULL,
  do.title = FALSE,
  verbose = TRUE,
  raster = NULL
)
}
\arguments{
\item{object}{\code{liger} object. Should call runTSNE before calling.}

\item{dataset1}{Name of first dataset (by default takes first two datasets for dataset1 and 2)}

\item{dataset2}{Name of second dataset}

\item{num.genes.show}{Number of genes displayed as y-axis labels in the gene loading plots at
the bottom (default 12)}

\item{num.genes}{Number of genes to show in word clouds (default 30).}

\item{mark.top.genes}{Plot points corresponding to top loading genes in different color (default
TRUE).}

\item{factor.share.thresh}{Use only factors with a dataset specificity less than or equal to
threshold (default 10).}

\item{log.fc.thresh}{Lower log-fold change threshold for differential expression in markers
(default 1).}

\item{umi.thresh}{Lower UMI threshold for markers (default 30).}

\item{frac.thresh}{Lower threshold for fraction of cells expressing marker (default 0).}

\item{pval.thresh}{Upper p-value threshold for Wilcoxon rank test for gene expression
(default 0.05).}

\item{do.spec.plot}{Include dataset specificity plot in printout (default TRUE).}

\item{max.val}{Value between 0 and 1 at which color gradient should saturate to max color. Set to
NULL to revert to default gradient scaling. (default 0.1)}

\item{pt.size}{Point size for plots (default 0.4).}

\item{option}{Colormap option to use for ggplot2's scale_color_viridis (default 'plasma').}

\item{zero.color}{Color to use for zero values (no expression) (default '#F5F5F5').}

\item{return.plots}{Return ggplot objects instead of printing directly (default FALSE).}

\item{axis.labels}{Vector of two strings to use as x and y labels respectively (default NULL).}

\item{do.title}{Include top title with cluster and Dataset Specificity (default FALSE).}

\item{verbose}{Print progress bar/messages (TRUE by default)}

\item{raster}{Rasterization of points (default NULL). Automatically convert to raster format if
there are over 100,000 cells to plot.}
}
\value{
List of ggplot plot objects (only if return.plots TRUE, otherwise prints plots to
  console).
}
\description{
Plots t-SNE coordinates of all cells by their loadings on each factor. Underneath it displays the
most highly loading shared and dataset-specific genes, along with the overall gene loadings
for each dataset.

It is recommended to call this function into a PDF due to the large number of
plots produced.
}
\examples{
\donttest{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
ligerex <- optimizeALS(ligerex, k = 5, max.iter = 1)
ligerex <- quantile_norm(ligerex)
ligerex <- runTSNE(ligerex)
plotGeneLoadings(ligerex, "stim", "ctrl", do.spec.plot = FALSE)
}
}
