% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEG_marker.R
\name{plotMarkerHeatmap}
\alias{plotMarkerHeatmap}
\title{Create heatmap for showing top marker expression in conditions}
\usage{
plotMarkerHeatmap(
  object,
  result,
  topN = 5,
  lfcThresh = 1,
  padjThresh = 0.05,
  pctInThresh = 50,
  pctOutThresh = 50,
  dedupBy = c("logFC", "padj"),
  groupBy = NULL,
  groupSize = 50,
  column_title = NULL,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object, with normalized data and metadata
to annotate available.}

\item{result}{The data.frame returned by \code{\link{runMarkerDEG}}.}

\item{topN}{Number of top features to be plot for each group. Default
\code{5}.}

\item{lfcThresh}{Hard threshold on logFC value. Default \code{1}.}

\item{padjThresh}{Hard threshold on adjusted P-value. Default \code{0.05}.}

\item{pctInThresh, pctOutThresh}{Threshold on expression percentage. These
mean that a feature will only pass the filter if it is expressed in more than
\code{pctInThresh} percent of cells in the corresponding cluster. Similarly
for \code{pctOutThresh}. Default \code{50} percent for both.}

\item{dedupBy}{When ranking by padj and logFC and a feature is ranked as top
for multiple clusters, assign this feature as the marker of a cluster when
it has the largest \code{"logFC"} in the cluster or has the lowest
\code{"padj"}. Default \code{"logFC"}.}

\item{groupBy}{Cell metadata variable names for cell grouping. Downsample
balancing will also be aware of this. Default \code{c("dataset",
"leiden_cluster")}.}

\item{groupSize}{Maximum number of cells in each group to be downsampled for
plotting. Default \code{50}.}

\item{column_title}{Title on the column. Default \code{NULL}.}

\item{...}{Parameter passed to wrapped functions in the inheritance order:
\code{\link{plotGeneHeatmap}}, \code{\link{.plotHeatmap}},
\code{ComplexHeatmap::\link[ComplexHeatmap]{Heatmap}}}
}
\description{
Create heatmap for showing top marker expression in conditions
}
\examples{
markerTable <- runMarkerDEG(pbmcPlot)
plotMarkerHeatmap(pbmcPlot, markerTable)
}
