% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{quantileNorm}
\alias{quantileNorm}
\alias{quantileNorm.liger}
\alias{quantileNorm.Seurat}
\title{Quantile Align (Normalize) Factor Loadings}
\usage{
quantileNorm(object, ...)

\method{quantileNorm}{liger}(
  object,
  quantiles = 50,
  reference = NULL,
  minCells = 20,
  nNeighbors = 20,
  useDims = NULL,
  center = FALSE,
  maxSample = 1000,
  eps = 0.9,
  refineKNN = TRUE,
  clusterName = "quantileNorm_cluster",
  seed = 1,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)

\method{quantileNorm}{Seurat}(
  object,
  reduction = "inmf",
  quantiles = 50,
  reference = NULL,
  minCells = 20,
  nNeighbors = 20,
  useDims = NULL,
  center = FALSE,
  maxSample = 1000,
  eps = 0.9,
  refineKNN = TRUE,
  clusterName = "quantileNorm_cluster",
  seed = 1,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} or Seurat object with valid factorization
result available (i.e. \code{\link{runIntegration}} performed in advance).}

\item{...}{Arguments passed to other S3 methods of this function.}

\item{quantiles}{Number of quantiles to use for quantile normalization.
Default \code{50}.}

\item{reference}{Character, numeric or logical selection of one dataset, out
of all available datasets in \code{object}, to use as a "reference" for
normalization. Default \code{NULL} use the dataset with the largest number of
cells.}

\item{minCells}{Minimum number of cells to consider a cluster shared across
datasets. Default \code{20}.}

\item{nNeighbors}{Number of nearest neighbors for within-dataset knn graph.
Default \code{20}.}

\item{useDims}{Indices of factors to use for shared nearest factor
determination. Default \code{NULL} uses all factors.}

\item{center}{Whether to center the data when scaling factors. Could be
useful for less sparse modalities like methylation data. Default
\code{FALSE}.}

\item{maxSample}{Maximum number of cells used for quantile normalization of
each cluster and factor. Default \code{1000}.}

\item{eps}{The error bound of the nearest neighbor search. Lower values give
more accurate nearest neighbor graphs but take much longer to compute.
Default \code{0.9}.}

\item{refineKNN}{whether to increase robustness of cluster assignments using
KNN graph. Default \code{TRUE}.}

\item{clusterName}{Variable name that will store the clustering result
in metadata of a \linkS4class{liger} object or a \code{Seurat} object.
Default \code{"quantileNorm_cluster"}}

\item{seed}{Random seed to allow reproducible results. Default \code{1}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{reduction}{Name of the reduction where LIGER integration result is
stored. Default \code{"inmf"}.}
}
\value{
Updated input object
\itemize{
 \item{liger method
 \itemize{
     \item{Update the \code{H.norm} slot for the alignment cell factor
         loading, ready for running graph based community detection
         clustering or dimensionality reduction for visualization.}
     \item{Update the \code{cellMata} slot with a cluster assignment basing
         on cell factor loading}
 }}
 \item{Seurat method
 \itemize{
     \item{Update the \code{reductions} slot with a new \code{DimReduc}
         object containing the aligned cell factor loading.}
     \item{Update the metadata with a cluster assignment basing on cell
         factor loading}
 }}
}
}
\description{
This process builds a shared factor neighborhood graph to
jointly cluster cells, then quantile normalizes corresponding clusters.

The first step, building the shared factor neighborhood graph, is performed
in SNF(), and produces a graph representation where edge weights between
cells (across all datasets) correspond to their similarity in the shared
factor neighborhood space. An important parameter here is \code{nNeighbors},
the number of neighbors used to build the shared factor space.

Next we perform quantile alignment for each dataset, factor, and cluster (by
stretching/compressing datasets' quantiles to better match those of the
reference dataset).
}
\examples{
pbmc <- quantileNorm(pbmcPlot)
}
