% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_measurements.R
\name{def_measurements}
\alias{def_measurements}
\title{Define measurements}
\usage{
def_measurements(
  measure_id = NULL,
  measurement_type = NULL,
  measurement_class = NULL
)
}
\arguments{
\item{measure_id}{\code{integer}. The unique identification number(s) of the
desired measurement(s) to return a definition for.}

\item{measurement_type}{\code{character}. Filter the returned definitions to
those of one or more named type(s) of measurement (e.g.,
"geochronological"). This is a less inclusive grouping than
\code{measurement_class}.}

\item{measurement_class}{\code{character}. Filter the returned definitions to
those of one or more named class(es) of measurement (e.g., "geochemical").
This is a more inclusive grouping than \code{measurement_type}.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{measure_id}: The unique identification number of the
measurement.
\item \code{name}: The name of the measurement.
\item \code{type}: Measurement type, less inclusive than class
\item \code{class}: Measurement class, more inclusive than type.
\item \code{t_units}: The total number of Macrostrat units containing this
measurement.
}
}
\description{
A function to retrieve the definitions of different measurements
that are included in the Macrostrat database. By default, all definitions
are returned.
}
\section{Developer(s)}{

William Gearty
}

\section{Reviewer(s)}{

Christopher D. Dean
}

\examples{
\donttest{
# Return all definitions
ex1 <- def_measurements()
# Return subsets of definitions
ex2 <- def_measurements(measure_id = c(1, 2, 4))
ex3 <- def_measurements(measurement_class = "geochemical")
}
}
\seealso{
External data:
\code{\link{def_drilling_sites}()},
\code{\link{get_eodp}()},
\code{\link{get_fossils}()},
\code{\link{get_measurements}()}

Geologic features and attributes:
\code{\link{def_econs}()},
\code{\link{def_environments}()},
\code{\link{def_grain_sizes}()},
\code{\link{def_lithologies}()},
\code{\link{def_lithology_att}()},
\code{\link{def_minerals}()},
\code{\link{def_structures}()}
}
\concept{defs_feat}
\concept{external}
