% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats.R
\name{get_stats}
\alias{get_stats}
\title{Retrieve Macrostrat database statistics}
\usage{
get_stats()
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{project_id}: The unique identification number of the Macrostrat
project.
\item \code{project}: The name of the Macrostrat project.
\item \code{columns}: The number of Macrostrat columns associated with the
project.
\item \code{packages}: The number of Macrostrat packages/sections
associated with the project.
\item \code{units}: The number of Macrostrat units associated with the
project.
\item \code{pbdb_collections}: The number of Paleobiology Database
collections associated with the project.
\item \code{measurements}: The number of measurements associated with the
project.
\item \code{t_polys}: The number of spatial polygons associated with the
project.
}
}
\description{
A function to retrieve various statistics about each Macrostrat
project in the Macrostrat database. Function is called without
user-specified arguments.
}
\section{Developer(s)}{

William Gearty
}

\section{Reviewer(s)}{

Bethany Allen
}

\examples{
\donttest{
# Return all project statistics
ex1 <- get_stats()
}
}
\seealso{
Macrostrat database metadata:
\code{\link{def_projects}()},
\code{\link{def_references}()},
\code{\link{def_sources}()}
}
\concept{meta}
