% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmargint-fn.R
\name{kernel4}
\alias{kernel4}
\title{Order 4 kernel}
\usage{
kernel4(x)
}
\arguments{
\item{x}{A vector of real numbers.}
}
\value{
A vector of the same length as \code{x} where each entry is \code{( 15/32 ) * ( 1 - x^2 ) * ( 3 - 7 * x^2 )} if \code{abs(x) < 1} and 0 otherwise.
}
\description{
This function evaluates a kernel of order 4.
}
\details{
This function evaluates a kernel of order 4. A kernel L is a kernel of order 4 if it integrates 1, the integrals of u^j L(u) are 0 for 1 <= j < 4 (j integer) and the integral of u^4 L(u) is different from 0.
}
\examples{
x <- seq(-2,2,length=10)
kernel4(x)

}
\author{
Alejandra Martinez, \email{ale_m_martinez@hotmail.com}, Matias Salibian-Barrera
}
