% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_document.R
\name{md_document}
\alias{md_document}
\title{Convert to a markdown document}
\usage{
md_document(variant = "markdown_strict", preserve_yaml = FALSE,
  toc = FALSE, toc_depth = 3, fig_width = 7, fig_height = 5,
  fig_retina = NULL, dev = "png", df_print = "default",
  includes = NULL, md_extensions = NULL, pandoc_args = NULL)
}
\arguments{
\item{variant}{Markdown variant to produce (defaults to "markdown_strict").
Other valid values are "markdown_github", "markdown_mmd",
markdown_phpextra", or even "markdown" (which produces pandoc markdown).
You can also compose custom markdown variants, see the
\href{http://pandoc.org/README.html}{pandoc online documentation}
for details.}

\item{preserve_yaml}{Preserve YAML front matter in final document.}

\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_depth}{Depth of headers to include in table of contents}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays. Defaults to
\code{NULL} which performs no scaling. A setting of 2 will work for all
widely used retina displays, but will also result in the output of
\code{<img>} tags rather than markdown images due to the need to set the
width of the image explicitly.}

\item{dev}{Graphics device to use for figure output (defaults to png)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method uses
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition
to the named methods you can also pass an arbitrary function to be used
for printing data frames. You can disable the \code{df_print} behavior entirely
by setting the option \code{rmarkdown.df_print} to \code{FALSE}.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to another variant of markdown (e.g.
strict markdown or github flavored markdown)
}
\details{
See the \href{http://rmarkdown.rstudio.com/markdown_document_format.html}{online
documentation} for additional details on using the \code{md_document} format.

R Markdown documents can have optional metadata that is used to generate a
document header that includes the title, author, and date. For more details
see the documentation on R Markdown \link[=rmd_metadata]{metadata}.
}
\examples{
\dontrun{
library(rmarkdown)

render("input.Rmd", md_document())

render("input.Rmd", md_document(variant = "markdown_github"))
}
}
