/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.meta;

import dmLab.discretizer.Discretizer;
import dmLab.discretizer.DiscretizerParams;
import dmLab.discretizer.change.DiscChange;
import dmLab.discretizer.chiMerge.DiscChiMerge;
import dmLab.discretizer.equalFrequency.EqualFrequency;
import dmLab.discretizer.equalRanges.EqualRanges;
import dmLab.discretizer.fayyadIrani.FayyadIrani;
import dmLab.utils.ArrayUtils;

public final class DiscRanges
implements Cloneable {
    private float[] ranges = null;

    public final float[] getRanges() {
        return this.ranges;
    }

    public final int getSize() {
        if (this.ranges == null) {
            return -1;
        }
        return this.ranges.length;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean find(float[] values, float[] decision, DiscretizerParams discParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        void discretizer2;
        Discretizer discretizer2;
        DiscretizerParams discretizerParams = discParams;
        if (values.length < discretizerParams.discIntervals) {
            return false;
        }
        discretizerParams = discParams;
        int algorithm = discretizerParams.discAlgorithm;
        if (algorithm == 1) {
            discretizer2 = new EqualRanges();
        } else if (discretizer2 == 2) {
            discretizer2 = new EqualFrequency();
        } else if (discretizer2 == 3) {
            discretizer2 = new DiscChiMerge();
        } else if (discretizer2 == 4) {
            discretizer2 = new DiscChange();
        } else if (discretizer2 == 5) {
            discretizer2 = new FayyadIrani();
        } else {
            return false;
        }
        ((Discretizer)discretizer2).findRanges((float[])var1_1, (float[])var2_2, (DiscretizerParams)var3_3);
        this.ranges = discretizer2.getRanges();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private int getRangeId(float value) {
        void var1_1;
        if (this.ranges == null) {
            return -1;
        }
        if (Float.isNaN(value)) {
            return -1;
        }
        if (value >= this.ranges[this.ranges.length - 1]) {
            return this.ranges.length - 1;
        }
        if (this.ranges.length <= 100) {
            return ArrayUtils.indexOf(this.ranges, value, false);
        }
        return ArrayUtils.indexOf(this.ranges, (float)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public final float[] getRange(float value) {
        void var2_3;
        void var1_2;
        if (Float.isNaN(value) || this.ranges == null) {
            return null;
        }
        int cutPointIndex = this.getRangeId(value);
        float[] range = new float[]{cutPointIndex == 0 ? Float.NEGATIVE_INFINITY : this.ranges[cutPointIndex - 1], cutPointIndex == this.ranges.length - 1 ? Float.POSITIVE_INFINITY : this.ranges[var1_2]};
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final String getRangeStr(float value) {
        void var1_2;
        if (Float.isNaN(value)) {
            return "NULL";
        }
        if (this.ranges == null) {
            return Float.toString(value);
        }
        float[] range = this.getRange(value);
        if (range == null) {
            return "NULL";
        }
        return "(" + range[0] + ";" + (float)var1_2[1] + "]";
    }

    /*
     * WARNING - void declaration
     */
    public final float getDiscreteValue(float value) {
        void var1_1;
        if (this.ranges == null || Float.isNaN(value)) {
            return value;
        }
        return this.ranges[this.getRangeId((float)var1_1)];
    }

    /*
     * WARNING - void declaration
     */
    public final DiscRanges clone() {
        void var1_1;
        DiscRanges d = new DiscRanges();
        new DiscRanges().ranges = (float[])this.ranges.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        if (this.ranges == null) {
            return "";
        }
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        while (i < this.ranges.length) {
            tmp.append(this.ranges[i]);
            if (i != this.ranges.length - 1) {
                tmp.append(", ");
            }
            ++i;
        }
        return var1_1.toString();
    }
}

