/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.tree;

import dmLab.classifier.attributeIndicators.J48NodeIndicators;
import dmLab.mcfs.tree.Tree;
import dmLab.mcfs.tree.parser.TreeParser;
import dmLab.utils.condition.Condition;
import java.util.ArrayList;
import java.util.Iterator;

public final class TreeNode {
    protected int level;
    private boolean leaf = false;
    private String decision = null;
    private TreeNode parent = null;
    private ArrayList<TreeNode> kids = new ArrayList();
    public J48NodeIndicators nodeIndicators;
    public Condition condition = new Condition();

    public TreeNode(TreeNode parent, Integer nodeID) {
        this.nodeIndicators = new J48NodeIndicators();
    }

    public final TreeNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        if (this.level >= 0) {
            int i = 0;
            while (i < this.level) {
                tmp.append("|   ");
                ++i;
            }
            tmp.append(this.condition.toString()).append("\t");
            if (this.leaf) {
                tmp.append(":").append(this.decision).append("\t");
            }
            tmp.append(this.nodeIndicators.toString());
        }
        Iterator<TreeNode> i = this.kids.iterator();
        while (i.hasNext()) {
            tmp.append("\n").append(i.next().toString());
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void setLevel(int level) {
        void var1_1;
        this.level = var1_1;
    }

    public final boolean isRoot() {
        return this.level == -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDecision(String decision) {
        void var1_1;
        if (decision == null || decision.equalsIgnoreCase("")) {
            this.leaf = false;
            return;
        }
        this.leaf = true;
        this.decision = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void parseTree(TreeParser treeReader) {
        void var2_2;
        TreeNode node;
        do {
            if ((node = treeReader.getNextNode()) == null || node.level <= this.level) continue;
            TreeNode treeNode = this;
            TreeNode treeNode2 = node;
            if (treeNode2.parent == null) {
                treeNode2.parent = treeNode;
            } else if (treeNode2.parent != treeNode) {
                System.err.println("Error! Parent already exists! ");
            }
            treeNode = node;
            treeNode2 = this;
            treeNode2.kids.add(treeNode);
            treeReader.flush();
            node.parseTree(treeReader);
        } while (node != null && var2_2.level > this.level);
    }

    public final void finalize(Tree tree) {
        tree.nodes.put(tree.nodeIterator++, this);
        int size = this.kids.size();
        int i = 0;
        while (i < size) {
            this.kids.get(i).finalize(tree);
            ++i;
        }
    }
}

