/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class PreConstructedLinearModel
extends Classifier
implements Serializable {
    static final long serialVersionUID = 2030974097051713247L;
    private double[] m_coefficients;
    private double m_intercept;
    private Instances m_instancesHeader;
    private int m_numParameters;

    public PreConstructedLinearModel(double[] coeffs, double intercept) {
        this.m_coefficients = coeffs;
        this.m_intercept = intercept;
        int count = 0;
        int i = 0;
        while (i < coeffs.length) {
            if (coeffs[i] != 0.0) {
                ++count;
            }
            ++i;
        }
        this.m_numParameters = count;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.m_instancesHeader = new Instances(instances, 0);
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        double result = 0.0;
        int i = 0;
        while (i < this.m_coefficients.length) {
            if (i != inst.classIndex() && !inst.isMissing(i)) {
                result += this.m_coefficients[i] * inst.value(i);
            }
            ++i;
        }
        return result += this.m_intercept;
    }

    public int numParameters() {
        return this.m_numParameters;
    }

    public double[] coefficients() {
        return this.m_coefficients;
    }

    public double intercept() {
        return this.m_intercept;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("\n" + this.m_instancesHeader.classAttribute().name() + " = ");
        boolean first = true;
        int i = 0;
        while (i < this.m_coefficients.length) {
            if (this.m_coefficients[i] != 0.0) {
                double c = this.m_coefficients[i];
                if (first) {
                    b.append("\n\t" + Utils.doubleToString(c, 12, 4).trim() + " * " + this.m_instancesHeader.attribute(i).name() + " ");
                    first = false;
                } else {
                    b.append("\n\t" + (this.m_coefficients[i] < 0.0 ? "- " + Utils.doubleToString(Math.abs(c), 12, 4).trim() : "+ " + Utils.doubleToString(Math.abs(c), 12, 4).trim()) + " * " + this.m_instancesHeader.attribute(i).name() + " ");
                }
            }
            ++i;
        }
        b.append("\n\t" + (this.m_intercept < 0.0 ? "- " : "+ ") + Utils.doubleToString(Math.abs(this.m_intercept), 12, 4).trim());
        return b.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }
}

