/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import java.util.Arrays;

public final class MCFSAutoParams {
    public static int AUTO = -1;
    private static String AUTO_LABEL = "auto";

    public static String valueToString(float value) {
        float f;
        if (value == (float)AUTO) {
            return AUTO_LABEL;
        }
        return Float.toString(f);
    }

    /*
     * WARNING - void declaration
     */
    public static float valueToFloat(String paramName, String value) {
        void var2_2;
        if (value.trim().equalsIgnoreCase(AUTO_LABEL)) {
            return AUTO;
        }
        try {
            float retVal = Float.valueOf(value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            String string;
            System.err.println("Warning! Incorrect value of " + string + ": " + (String)var1_1 + ". Using default value = 'auto'.");
            return AUTO;
        }
        return (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int setProjectionSize(float projectionSize, int projectionSizeMin, int projectionSizeMax, FArray array) {
        void var0_1;
        void var3_4;
        float projectionSizeValue22;
        int projectionSizeValue22;
        FArray fArray = array;
        int attributes = fArray.attributes.length - 1;
        if (projectionSize == (float)AUTO) {
            projectionSizeValue22 = (int)Math.round(Math.sqrt(attributes));
        } else if (projectionSizeValue22 > 0.0f && projectionSizeValue22 < 1.0f) {
            projectionSizeValue22 = Math.round((float)attributes * projectionSizeValue22);
        } else if (projectionSizeValue22 >= 1.0f) {
            projectionSizeValue22 = (int)projectionSizeValue22;
        } else {
            System.err.println("Warning! Incorrect value of projectionSize:" + projectionSizeValue22 + ". Using default value = 'auto'.");
            projectionSizeValue22 = (int)Math.round(Math.sqrt(attributes));
        }
        fArray = var3_4;
        if (projectionSizeValue22 >= fArray.attributes.length) {
            System.err.println("Warning! projectionSize(m) is larger than number of attributes. Using max value = ".concat(String.valueOf(attributes)));
            projectionSizeValue22 = attributes;
        }
        if (projectionSizeValue22 < projectionSizeMin) {
            void var1_2;
            System.err.println("Warning! ProjectionSize(m) < 1. Using min value = ".concat(String.valueOf(projectionSizeMin)));
            projectionSizeValue22 = var1_2;
        }
        if (projectionSizeValue22 > projectionSizeMax) {
            void var2_3;
            System.err.println("Warning! ProjectionSize(m) = " + projectionSizeValue22 + ". Using max value = " + projectionSizeMax);
            projectionSizeValue22 = var2_3;
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int setProjections(int projections, float projectionSize, int featureFreq, FArray array) {
        int n;
        int projectionsValue;
        int attributes = array.attributes.length - 1;
        if (projections == AUTO) {
            projectionsValue = Math.round((float)attributes / projectionSize * (float)featureFreq);
        } else if (projectionsValue <= 0) {
            void var2_2;
            void var1_1;
            void var3_4;
            System.err.println("Warning! Incorrect value of projections: " + projectionsValue + " Using default value = 'auto'.");
            projectionsValue = Math.round((float)var3_4 / var1_1 * (float)var2_2);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static float balanceModel(double ratio) {
        void var3_3;
        void var2_2;
        double d;
        double[] ratioModel = new double[]{0.25, 0.2, 0.15, 0.1, 0.075, 0.05, 0.025, 0.01, 0.0075, 0.005, 0.0025, 0.001};
        double[] paramModel = new double[]{1.0, 1.0, 1.2, 1.5, 1.75, 2.0, 2.5, 3.0, 3.25, 3.5, 3.75, 4.0};
        int id = 0;
        while (id < 12) {
            if (ratio > ratioModel[id]) break;
            ++id;
        }
        if (id == 0) {
            return (float)paramModel[0];
        }
        if (id >= 12) {
            return (float)paramModel[11];
        }
        double a = (d - ratioModel[id - 1]) / (ratioModel[id] - var2_2[id - 1]);
        float f = (float)(paramModel[id - 1] + a * (paramModel[id] - var3_3[id - 1]));
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] getBalancedClassSizes(float balance, FArray array) {
        float f;
        void var2_3;
        void var1_1;
        float balanceValue;
        if (!array.isTargetNominal()) {
            return null;
        }
        int decIndex = array.getDecAttrIdx();
        int[] classSizes = ArrayUtils.distribution(array.getColumn(decIndex), array.getDecValues());
        float minSize = MathUtils.minValue(ArrayUtils.int2float(classSizes));
        float maxSize = MathUtils.maxValue(ArrayUtils.int2float(classSizes));
        float classSizeRatio = minSize / maxSize;
        int[] balancedClassSizes = (int[])classSizes.clone();
        if (balance == 0.0f) {
            balanceValue = 0.0f;
            balancedClassSizes = null;
        } else if (!(balanceValue >= 1.0f)) {
            if (balanceValue == (float)AUTO) {
                balanceValue = MCFSAutoParams.balanceModel(classSizeRatio);
            } else {
                System.err.println("Warning! Incorrect value of balance: " + balanceValue + " Using default value = 'auto'.");
                balanceValue = MCFSAutoParams.balanceModel(classSizeRatio);
            }
        }
        if (balanceValue > 1.0f) {
            double b = (double)minSize / Math.pow(minSize, 1.0 / (double)balanceValue);
            int i = 0;
            while (i < balancedClassSizes.length) {
                int newSize = (int)Math.ceil(b * Math.pow(balancedClassSizes[i], 1.0 / (double)balanceValue));
                if (balancedClassSizes[i] > newSize) {
                    balancedClassSizes[i] = newSize;
                }
                ++i;
            }
        }
        if ((balanceValue == 0.0f || balanceValue == 1.0f) && (double)classSizeRatio < 0.1) {
            System.err.println("Warning! Classes are imbalanced (classSizeRatio = " + DiscFunctions.formatFloat(classSizeRatio, 5) + "). It is recomended to set mcfs.balance = auto");
        }
        System.out.print("Classes = " + Arrays.toString(array.dictionary.toString(var1_1.getDecValues())) + ", Sizes = " + Arrays.toString((int[])var2_3));
        if (balanceValue > 1.0f) {
            System.out.print(", balanced = " + Arrays.toString(balancedClassSizes));
        }
        System.out.println(", classSizeRatio = " + classSizeRatio + ", balanceValue = " + f);
        return balancedClassSizes;
    }
}

