% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{twedt_dist_measures}
\alias{twedt_dist_measures}
\title{Repeated measures and multivariate measures of perceived distance}
\format{
A data frame with 230 rows and 7 columns
\tabular{lll}{
\code{[ ,1]} \tab \code{Subject}           \tab Unique identifier for each 
                                                 participant \cr \cr\cr
\code{[, 2]} \tab \code{Physical Distance} \tab {Physical distance from the 
                                                 participant to the target 
                                                 cone, in meters} \cr \cr\cr
\code{[, 3]} \tab \code{Blindwalk Away}    \tab {Participants put on the 
                                                 blindfold after viewing the 
                                                 target.} \cr
             \tab                          \tab {Next, participants took one step to 
                                                 the left and turned 180 degrees to 
                                                 face the opposite direction.}\cr
             \tab                          \tab {Participants were instructed to walk
                                                 forward until they had walked the 
                                                 original distance to the target.} \cr\cr\cr
                                                                                                                                            
\code{[, 4]} \tab \code{Blindwalk Toward}  \tab {Participants put on the 
                                                 blindfold after viewing the 
                                                 target.} \cr 
             \tab                          \tab {Next, participants walked forward until
                                                 they thought they had reached the 
                                                 target cone.}\cr\cr\cr
\code{[, 5]} \tab \code{Triangulated BW}   \tab {Participants put on the 
                                                 blindfold after viewing the 
                                                 target.} \cr
             \tab                          \tab {Next, participants
                                                 turned right 90 degrees and walked
                                                 forward 5 meters.} \cr
             \tab                          \tab {The experimenter told 
                                                 participants when to stop walking.} \cr
             \tab                          \tab  {Finally, participants turned to face 
                                                 toward the target and walked 
                                                 forward two steps.} \cr\cr\cr
\code{[, 6]} \tab \code{Verbal}            \tab {Participants stated the distance 
                                                 between the target cone and themselves, 
                                                 in feet and inches} \cr\cr\cr
\code{[, 7]} \tab \code{Visual Matching}   \tab {An experimenter stood next to
                                                 the target cone and walked 
                                                 away from the cone in a} \cr
             \tab                          \tab  {straight line that was 
                                                 perpendicular to the extent 
                                                 between the target and the 
                                                 participant.} \cr
             \tab                          \tab  {Participants instructed the experimenter 
                                                 to stop walking when they 
                                                 thought that the distance } \cr
             \tab                          \tab  {between the target and the 
                                                 experimenter was equal to 
                                                 the target distance.} \cr
}
}
\source{
Twedt, E. Bakdash, J.Z., and Proffitt, D.R. (2022). 
Repeated and multivariate measures of perceived distance (Dataset)
\doi{https://doi.org/10.5281/zenodo.6967162}
}
\usage{
twedt_dist_measures
}
\description{
A dataset of repeated measures of distance perception  
at  physical distances of 7, 8, 9, 10, and 11 meters. The data are also 
multivariate, with five  dependent measures of distance perception. This is a 
5 (physical distance) x 5 (dependent measure) within-participants design 
with a sample size of 46. 
Note data is missing for 15 trials due participant and experimenter errors.
}
