% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareSimulationData.R
\name{PrepareSimulationData}
\alias{PrepareSimulationData}
\title{PrepareSimulationData}
\usage{
PrepareSimulationData(stan_est, policies, nsims = 30)
}
\arguments{
\item{stan_est}{Stan fit model from FitMDCEV}

\item{policies}{list containing
price_p with additive price increases, and
dat_psi_p with new psi data}

\item{nsims}{Number of simulation draws to use for parameter uncertainty}
}
\value{
A list with individual-specific data (df_indiv) and common data (df_common)
and n_classes for number of classes and model_num for model type
}
\description{
Prepare Data for WTP simulation
}
\examples{
\donttest{
data(data_rec, package = "rmdcev")
mdcev_est <- FitMDCEV(psi_formula = ~ 1,
data = subset(data_rec, id < 500),
model = "hybrid0",
algorithm = "MLE")

policies <- CreateBlankPolicies(npols = 2,
ngoods = mdcev_est[["stan_data"]][["J"]],
dat_psi = mdcev_est[["stan_data"]][["dat_psi"]],
price_change_only = TRUE)

df_sim <- PrepareSimulationData(mdcev_est, policies)
}
}
