% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdcev.R, R/mdcev.methods.R
\name{mdcev}
\alias{mdcev}
\alias{print.mdcev}
\alias{summary.mdcev}
\alias{print.summary.mdcev}
\title{mdcev}
\usage{
mdcev(
  formula = NULL,
  data,
  weights = NULL,
  model = c("alpha", "gamma", "hybrid", "hybrid0", "kt_ee"),
  n_classes = 1,
  fixed_scale1 = 0,
  trunc_data = 0,
  psi_ascs = NULL,
  gamma_ascs = 1,
  seed = "123",
  max_iterations = 2000,
  jacobian_analytical_grad = 1,
  initial.parameters = NULL,
  hessian = TRUE,
  algorithm = c("MLE", "Bayes"),
  flat_priors = NULL,
  print_iterations = TRUE,
  prior_psi_sd = 10,
  prior_gamma_sd = 10,
  prior_phi_sd = 10,
  prior_alpha_shape = 1,
  prior_scale_sd = 1,
  prior_delta_sd = 10,
  gamma_nonrandom = 0,
  alpha_nonrandom = 0,
  std_errors = "deltamethod",
  n_draws = 50,
  keep_loglik = 0,
  random_parameters = "fixed",
  show_stan_warnings = TRUE,
  n_iterations = 200,
  n_chains = 4,
  n_cores = 4,
  max_tree_depth = 10,
  adapt_delta = 0.8,
  lkj_shape_prior = 4,
  ...
)

\method{print}{mdcev}(
  x,
  digits = max(3, getOption("digits") - 3),
  width = getOption("width"),
  ...
)

\method{summary}{mdcev}(object, printCI = FALSE, ...)

\method{print}{summary.mdcev}(x, ...)
}
\arguments{
\item{formula}{Formula for the model to be estimated. The formula is divided in
three parts, separated by the symbol \code{|}. The first part is reserved for
alternative-specific and individual-specific variables in the psi parameters.
Note that alternative-specific constants are handled by the \code{psi_ascs} argument.
The second part corresponds for individual-specific variables that enter in the probability
assignment in models with latent classes. The third part is reserved for the $q_k$ variables
included in the $phi_k$ parameters in the KT model specification used in environmental economics
\code{model = "kt_ee"}.}

\item{data}{The (IxJ) data to be passed to Stan of class \code{\link[rmdcev]{mdcev.data}}
including 1) id, 2) alt, 3) choice, 4) price, 5) income, and columns for alternative-specific and
individual specific variables. Note: I is number of individuals and J is number of non-numeraire alternatives.}

\item{weights}{an optional vector of weights. Default to 1.}

\item{model}{A string indicating which model specification is estimated.
The options are "alpha", "gamma", "hybrid" and "hybrid0" for the MDCEV model and "kt_ee" for the environmental
economics Kuhn-Tucker specification.}

\item{n_classes}{The number of latent classes. Note that the LC model is automatically estimated as long as the
prespecified number of classes is set greater than 1.}

\item{fixed_scale1}{Whether to fix scale at 1.}

\item{trunc_data}{Whether the estimation should be adjusted for truncation of non-numeraire alternatives.
This option is useful if the data only includes individuals with positive non-numeraire consumption levels
such as recreation data collected on-site. To account for the truncation of consumption, the likelihood is
normalized by one minus the likelihood of observing zero consumption for all non-numeraire alternatives
(i.e. likelihood of positive consumption) following Englin, Boxall and Watson (1998) and von Haefen (2003).}

\item{psi_ascs}{Whether to include alternative-specific psi parameters. The first alternative is used as
the reference category. Only specify to 1 for MDCEV models.}

\item{gamma_ascs}{Indicator to include alternative-specific gammas parameters.}

\item{seed}{Random seed.}

\item{max_iterations}{Maximum number of iterations in MLE.}

\item{jacobian_analytical_grad}{indicator whether to use analytical gradient method for Jacobian (=1) or numerical
gradient method (=0). For "kt_ee" model only,}

\item{initial.parameters}{The default for fixed and random parameter specifications is to use random starting values.
For LC models, the default is to use slightly adjusted MLE point estimates from the single class model.
Initial parameter values should be included in a named list. For example, the LC "hybrid" specification
initial parameters can be specified as:
initial.parameters = list(psi = array(0, dim = c(K, num_psi)),
                            gamma = array(1, dim = c(K, num_alt)),
                            alpha = array(0.5, dim = c(K, 0)),
                            scale = array(1, dim = c(K)))
where K is the number of classes (i.e. K = 1 is used for single class models),
num_psi is number of psi parameters, and num_alt is number of non-numeraire alternatives.}

\item{hessian}{Whether to keep the Hessian matrix}

\item{algorithm}{Either "Bayes" for Bayes or "MLE" for maximum likelihood estimation.}

\item{flat_priors}{indicator if completely uninformative priors should be specified. Defaults to 1 if MLE used and 0 if Bayes used. If using MLE and set flat_priors = 0,
penalized MLE is used and the optimizing objective is augmented with the priors.}

\item{print_iterations}{Whether to print iteration information}

\item{prior_psi_sd}{standard deviation for normal prior with mean 0.}

\item{prior_gamma_sd}{standard deviation for half-normal prior with mean 1.}

\item{prior_phi_sd}{standard deviation for normal prior with mean 0.}

\item{prior_alpha_shape}{shape parameter for beta distribution.}

\item{prior_scale_sd}{standard deviation for half-normal prior with mean 0.}

\item{prior_delta_sd}{standard deviation for normal prior with mean 0.}

\item{gamma_nonrandom}{indicator set to 1 if gamma parameters should not be random (i.e. no standard deviation).}

\item{alpha_nonrandom}{indicator set to 1 if alpha parameters should not be random (i.e. no standard deviation).}

\item{std_errors}{Compute standard errors using the delta method ("deltamethod")
or multivariate normal draws ("mvn"). The default is "deltamethod". Note that mvn parameter draws should be
used to incorporate parameter uncertainty for demand and welfare simulation. For maximum likelihood estimation only.}

\item{n_draws}{The number of multivariate normal draws for standard error calculations if "mvn" is specified.}

\item{keep_loglik}{Whether to keep the log_lik calculations}

\item{random_parameters}{The form of the covariance matrix for
Bayes. Can be 'fixed' for no random parameters, 'uncorr' for uncorrelated random parameters, or
'corr' for correlated random parameters.}

\item{show_stan_warnings}{Whether to show warnings from Stan.}

\item{n_iterations}{The number of iterations to use in Bayesian estimation. The default is for the number of
iterations to be split evenly between warmup and posterior draws. The number of warmup draws can be directly controlled using the warmup argument (see \code{rstan::sampling}).}

\item{n_chains}{The number of independent Markov chains in Bayesian estimation.}

\item{n_cores}{The number of cores used to execute the Markov chains in parallel in Bayesian estimation.
Can set using options(mc.cores = parallel::detectCores()).}

\item{max_tree_depth}{https://mc-stan.org/misc/warnings.html#maximum-treedepth-exceeded}

\item{adapt_delta}{https://mc-stan.org/misc/warnings.html#divergent-transitions-after-warmup}

\item{lkj_shape_prior}{Prior for Cholesky matrix}

\item{...}{Additional parameters to pass on to \code{rstan::stan}
and \code{rstan::sampling}.}

\item{x, object}{an object of class `mdcev`}

\item{digits}{the number of digits,}

\item{width}{the width of the printing,}

\item{printCI}{set to TRUE to print 95\% confidence intervals}
}
\value{
A object of class mdcev
}
\description{
Fit a MDCEV model using MLE or Bayes
}
\examples{
\donttest{
data(data_rec, package = "rmdcev")

data_rec <- mdcev.data(data_rec, subset = id <= 500, id.var = "id",
                alt.var = "alt", choice = "quant")

mdcev_est <- mdcev( ~ 0,
data = data_rec,
model = "hybrid0",
algorithm = "MLE")
}
}
