% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_method.R
\name{dmetalog}
\alias{dmetalog}
\title{Generate density values with quantiles from a metalog object.
This is done through a newtons method approximation.}
\usage{
dmetalog(m, q, term = 3)
}
\arguments{
\item{m}{metalog object created from \code{metalog()}}

\item{q}{y vector of quantiles}

\item{term}{which metalog distribution to sample from}
}
\value{
A numeric vector of probabilities corresponding to the q quantile
  vector
}
\description{
Generate density values with quantiles from a metalog object.
This is done through a newtons method approximation.
}
\examples{
# Load example data
\dontrun{
data("fishSize")

# Create a bounded metalog object
myMetalog <- metalog(fishSize$FishSize,
                     bounds=c(0, 60),
                     boundedness = 'b',
                     term_limit = 9,
                     term_lower_bound = 9)

s <- dmetalog(myMetalog,q=c(3,10,25),term = 9)
}
}
