% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_method.R
\name{qmetalog}
\alias{qmetalog}
\title{Generate quantiles with a probability from a metalog object}
\usage{
qmetalog(m, y, term = 3)
}
\arguments{
\item{m}{metalog object created from \code{metalog()}}

\item{y}{vector of probabilities}

\item{term}{which metalog distribution to sample from}
}
\value{
A numeric vector of quantiles corresponding to the y probability
  vector
}
\description{
Generate quantiles with a probability from a metalog object
}
\examples{
# Load example data
\dontrun{
data("fishSize")

# Create a bounded metalog object
myMetalog <- metalog(fishSize$FishSize,
                     bounds=c(0, 60),
                     boundedness = 'b',
                     term_limit = 9,
                     term_lower_bound = 9)

s <- qmetalog(myMetalog,y=c(0.25,0.5,0.7),term = 9)
}
}
