% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIntercepts.r
\name{plotIntercepts}
\alias{plotIntercepts}
\title{Plot Intercepts}
\usage{
plotIntercepts(fit)
}
\arguments{
\item{fit}{an \code{orm} or \code{lrm} fit object, usually with a numeric dependent variable having many levels}
}
\value{
nothing; only plots
}
\description{
Plots the step function corresponding to the intercepts in a \code{orm} or \code{lrm} model.  This can be thought
of as the link function of the covariate-adjusted empirical cumulative distribution function
(actually 1 - ECDF).  It is
also related to q-q plots.  For example, if a probit link function is an appropriate choice, and the
residuals actually had a normal distribution (not needed by the semiparametric ordinal model), the step
function of the intercepts would form a straight line.
}
\examples{
\dontrun{
f <- orm(y ~ x1 + x2 + x3)
plotIntercepts(f)
}
}
\author{
Frank Harrell
}
