% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{fromDatatoMzQC}
\alias{fromDatatoMzQC}
\title{Allow conversion of plain named lists to mzQC objects}
\usage{
fromDatatoMzQC(mzqc_class, data)
}
\arguments{
\item{mzqc_class}{Prototype of the class to convert 'data' into}

\item{data}{A datastructure of R lists/arrays as obtained by 'jsonlite::fromJSON()'}
}
\description{
The plain-R representation of your mzQC objects must be wrapped in an outer list,
if your mzQC object representation is already a list
because upon detecting lists, this function will call 'class$fromData(element)' for every element.
}
\examples{
 data = MzQCcvParameter$new("acc", "myName", "value")
 data_recovered = fromDatatoMzQC(MzQCcvParameter, list(jsonlite::fromJSON(jsonlite::toJSON(data))))
 data_recovered

}
