% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{toQCMetric}
\alias{toQCMetric}
\title{Create an 'MzQCqualityMetric' object from two inputs}
\usage{
toQCMetric(id, value, on_violation = c("error", "warn"))
}
\arguments{
\item{id}{The CV accession}

\item{value}{The data, as computed by some QC software in the required format.}

\item{on_violation}{What to do when 'value' is not of the correct type (according to the given 'id')? Default: "error"; or "warn"}
}
\value{
An MzQCanalysisSoftware object
}
\description{
Create an 'MzQCqualityMetric' object from two inputs
}
\details{
The inputs are:
\itemize{
\item an ID of a QC metric, e.g. "MS:4000059" (number of MS1 spectra)
\item a value
}

The value must be in the correct format depending on the metric. The value type (see below) is checked (a warning/error is given if mismatching):
The following requirements for values apply:
\itemize{
\item single value: R single value; the unit is obtained from the CVs 'has_units'
\item n-tuple: an R vector, e.g. using c(1,2,3), i.e. all values have the same type; the unit is obtained from the CVs 'has_units'
\item table:  an R data.frame(); all columns defined using CVs 'has_column' must be present (a warning/error is given otherwise)
\item matrix: an R matrix, i.e. all values have the same type; the unit is obtained from the CVs 'has_units'
}

Upon violation, an error (default) or a warning is emitted:
\preformatted{
   toQCMetric(id = "MS:4000059", value = data.frame(n = 1)) # errors: wrong value format
 }
}
\examples{
   toQCMetric(id = "MS:4000059", value = 13405) # number of MS1 spectra

}
