% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{toQCMetric}
\alias{toQCMetric}
\title{Create an 'MzQCqualityMetric' object from two inputs (id and value).}
\usage{
toQCMetric(
  id,
  value,
  on_violation = c("error", "warn"),
  allow_unknown_id = FALSE
)
}
\arguments{
\item{id}{The CV accession}

\item{value}{The data, as computed by some QC software in the required format.}

\item{on_violation}{What to do when 'value' is not of the correct type (according to the given 'id')? Default: "error"; or "warn"}

\item{allow_unknown_id}{Allows invalid accession, and also does not check the value type; if 'FALSE' this function errors}
}
\value{
An MzQCanalysisSoftware object
}
\description{
Create an 'MzQCqualityMetric' object from two inputs (id and value).
}
\details{
The inputs are:
\itemize{
\item an ID of a QC metric, e.g. "MS:4000059" (number of MS1 spectra)
\item a value
}

The value must be in the correct format depending on the metric. The value type (see below) is checked (a warning/error is given if mismatching):
The following requirements for values apply:
\itemize{
\item single value: R single value; the unit is deduced from the CVs 'has_units'
\item n-tuple: an R vector, e.g. using c(1,2,3), i.e. all values have the same type; the unit is deduced from the CVs 'has_units'
\item table:  an R list(); all columns defined using CVs 'has_column' must be present (a warning/error is given otherwise)
\item matrix: an R matrix, i.e. all values have the same type; the unit is deduced from the CVs 'has_units'
}

Upon violation of the value type (e.g. data.frame instead of single value), an error or a warning is emitted (see @p on_violation):
\preformatted{
   toQCMetric(id = "MS:4000059", value = data.frame(n = 1)) # errors: wrong value format
 }
}
\examples{
   ## single value
   toQCMetric(id = "MS:4000059", value = 13405) # number of MS1 spectra

   ## n-tuple
   toQCMetric(id = "MS:4000051", value = c(31.3, 35.99, 38.44)) # XIC-FWHM quantiles

   ## table
   toQCMetric(id = "MS:4000063",  # MS2 known precursor charges fractions
              value = list("MS:1000041" = 1:3,
                           "UO:0000191" = c(0.7, 0.6, 0.8)))

   ## test an invalid CV accession/id
   toQCMetric(id = "MS:0000", value = "ID_is_not_valid", allow_unknown_id = TRUE)

   \donttest{
   ## matrix (there is no example in the CV yet, so this cannot be tested)
   toQCMetric(id = "MS:400000?", value = matrix(1:12, nrow = 3, ncol = 4)) # ???
   # does not work since the 'id' is not derived from a valid value type
   toQCMetric(id = "MS:0000000", value = "ID_is_not_valid")

   # does not work, since the ID is unknown and 'allow_unknown_id' is FALSE by default
   toQCMetric(id = "MS:0000", value = "ID_is_not_valid")
   }

}
