% Generated by roxygen2 (4.0.2.9000): do not edit by hand
\docType{package}
\name{rncl}
\alias{rncl}
\alias{rncl-package}
\title{rncl: An R interface to the NEXUS Class Library}
\usage{
rncl(file, file.format = c("nexus", "newick"), spacesAsUnderscores = TRUE,
  char.all = TRUE, polymorphic.convert = TRUE, levels.uniform = TRUE, ...)
}
\arguments{
\item{file}{path to a NEXUS or Newick file}

\item{file.format}{something a character string indicating the
type of file to be parsed.}

\item{spacesAsUnderscores}{In the NEXUS file format white spaces
are not allowed in taxa labels and are represented by
underscores. Therefore, NCL converts underscores found in taxa
labels in the NEXUS file into white spaces (e.g. \code{species_1}
will become \code{"species 1"}. If you want to preserve the
underscores, set as TRUE, the default).}

\item{char.all}{If TRUE (default), returns all characters, even
those excluded in the NEXUS file (only when NEXUS file contains
DATA block).}

\item{polymorphic.convert}{If TRUE (default), converts polymorphic
characters to missing data (only when NEXUS file contains DATA
block).}

\item{levels.uniform}{If TRUE (default), uses the same levels for
all characters (only when NEXUS file contains DATA block).}

\item{...}{additional parameters (currently not in use).}
}
\value{
A list that contains the elements extracted from a NEXUS
or a Newick file.
}
\description{
rncl provides an interface to the NEXUS Class Library (NCL), a C++
library intended to parse valid NEXUS files as well as other
common formats used in phylogenetic analysis. Currently, rncl
focuses on parsing trees and supports both NEXUS and Newick
formatted files. Because NCL is used by several phylogenetic
software (e.g., MrBayes, Garli), rncl can parse files generated by
these programs. However, other popular programs (including BEAST)
use an extension of the NEXUS file format, and if trees can be
imported, associated annotations (e.g., confidence intervals on
the time since divergence) cannot.

Returns a list of the elements contained in a NEXUS file used to
build phylogenetic objects in R
}
\details{
NCL can also parse data associated with species included in NEXUS
files. If you are interested in importing such data, see the
phylobase package.

NEXUS is a common file format used in phylogenetics to represent
phylogenetic trees, and other types of phylogenetic data. This
function uses NCL (the NEXUS Class Library) to parse NEXUS, Newick
or other common phylogenetic file formats, and returns the
relevant elements as a list. \code{phylo} (from the ape package)
or \code{phylo4} (from the phylobase package) can be constructed
from the elements contained in this list.
}
\author{
Francois Michonneau
}
\references{
Maddison DR, Swofford DL, Maddison WP (1997). "NEXUS:
An extensible file format for systematic information". Systematic
Biology 46(4) : 590-621. doi:10.1093/sysbio/46.4.590

Lewis, P. O. 2003. NCL: a C++ class library for interpreting data
files in NEXUS format. Bioinformatics 19 (17) : 2330-2331.
}

