% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot_function.R
\name{forestplot}
\alias{forestplot}
\title{Comparator-specific forest plot for network meta-analysis}
\usage{
forestplot(full, compar, drug_names)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{compar}{A character to indicate the comparator intervention. It must be
any name found in \code{drug_names}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}.}
}
\value{
A panel of two forest plots: (1) a forest plot on the effect
  estimates and predictions of comparisons with the selected intervention in
  the network, and (2) a forest plot on the posterior mean and 95\% credible
  interval of SUCRA values of the interventions (Salanti et al., 2011).
}
\description{
Provides a forest plot with the posterior median and 95\% credible
  and prediction intervals for comparisons with the selected intervention
  (comparator) in the network, and a forest plot with the corresponding
  SUCRA values.
}
\details{
The y-axis of the forest plot on \bold{effect sizes} displays the
  labels of the interventions in the network; the selected intervention that
  comprises the \code{compar} argument is annotated in the plot with the
  label 'Comparator intervention'.
  For each comparison with the selected intervention, the 95\% credible and
  prediction intervals are displayed as overlapping lines in different
  colours. The corresponding numerical results are displayed above each line:
  95\% credible intervals are found in parentheses, and 95\% predictive
  intervals are found in brackets. Odds ratios, relative risks, and ratio of
  means are reported in the original scale after exponentiation of the
  logarithmic scale.

  The y-axis for the forest plot on \bold{SUCRA} values displays the
  labels of the interventions in the network.
  The corresponding numerical results are displayed above each line.
  Three coloured rectangles appear in the forest plot: a red rectangle for
  SUCRA values up to 50\%, a yellow rectangular for SUCRA values between
  50\% and 80\%, and a green rectangle for SUCRA values over 80\%.
  Interventions falling at the green area are considered as the highest
  ranked interventions, whilst interventions falling at the red area are
  considered as the lowest ranked interventions.

  In both plots, the interventions are sorted in descending order of their
  SUCRA values.

  \code{forestplot} can be used only for a network of interventions.
  Otherwise, the execution of the function will be stopped and an error
  message will be printed on the R console.
}
\examples{
data("nma.liu2013")

# Show the first six trials of the dataset (one-trial-per-row format)
head(nma.liu2013)

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_liu.rds', package = 'rnmamod'))

# The names of the interventions in the order they appear in the dataset
interv_names <- c("placebo", "pramipexole", "serotonin-norepinephrine
reuptake inhibitor", "serotonin reuptake inhibitor", "tricyclic
antidepressant", "pergolide")

# Create the forest plot
forestplot(full = res,
           compar = "placebo",
           drug_names = interv_names)

}
\references{
Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
doi: 10.1016/j.jclinepi.2010.03.016
}
\seealso{
\code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
