% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnndescent.R
\name{neighbor_overlap}
\alias{neighbor_overlap}
\title{Overlap between the indices of two nearest neighbor graphs}
\usage{
neighbor_overlap(idx1, idx2, k = NULL, ret_vec = FALSE)
}
\arguments{
\item{idx1}{Indices of a nearest neighbor graph, i.e. a matrix of nearest
neighbor indices. Can also be a list containing an \code{idx} element.}

\item{idx2}{Indices of a nearest neighbor graph, i.e. a matrix of nearest
neighbor indices. Can also be a list containing an \code{idx} element. This is
considered to be the ground truth.}

\item{k}{Number of neighbors to consider. If \code{NULL}, then the minimum of the
number of neighbors in \code{idx1} and \code{idx2} is used.}

\item{ret_vec}{If \code{TRUE}, also return a vector containing the per-item overlap.}
}
\value{
The mean overlap between \code{idx1} and \code{idx2}. If \code{ret_vec = TRUE},
then a list containing the mean overlap and the overlap of each item in
is returned with names \code{mean} and \code{overlaps}, respectively.
}
\description{
Calculates the mean average number of neighbors in common between the two
graphs. The per-item overlap can also be returned. This function can be
useful as a measure of accuracy of approximation algorithms, if the
exact nearest neighbors are known, or as a measure of diversity of two
different approximate graphs.
}
\details{
The graph format is the same as that returned by e.g. \code{\link[=nnd_knn]{nnd_knn()}} and should
be of dimensions n by k, where n is the number of points and k is the number
of neighbors. If you pass a neighbor graph directly, the index matrix will be
extracted if present. If the two graphs have different numbers of neighbors,
then the smaller number of neighbors is used.
}
\examples{
set.seed(1337)
# Generate two random neighbor graphs for iris
iris_rnn1 <- random_knn(iris, k = 15)
iris_rnn2 <- random_knn(iris, k = 15)

# Overlap between the two graphs
mean_overlap <- neighbor_overlap(iris_rnn1, iris_rnn2)

# Also get a vector of per-item overlap
overlap_res <- neighbor_overlap(iris_rnn1, iris_rnn2, ret_vec = TRUE)
summary(overlap_res$overlaps)
}
