% Generated by roxygen2 (4.0.1): do not edit by hand
\name{erddap_info}
\alias{erddap_info}
\title{Get information on an ERDDAP dataset.}
\usage{
erddap_info(datasetid, callopts = list())
}
\arguments{
\item{datasetid}{Dataset id}

\item{callopts}{Further args passed on to httr::GET (must be a named parameter)}
}
\value{
A list of length two
\itemize{
 \item variables Data.frame of variables and their types
 \item alldata List of data variables and their full attributes
}
}
\description{
Gives back a brief data.frame for quick inspection and a list of more complete
metadata on the dataset.
}
\examples{
\dontrun{
erddap_info(datasetid='erdCalCOFIfshsiz')
out <- erddap_info(datasetid='erdCinpKfmBT')
## See brief overview of the variables and range of possible values, if given
out$variables
## all information on longitude
out$alldata$longitude
## all information on Haliotis_corrugata_Mean_Density
out$alldata$Haliotis_corrugata_Mean_Density
}
}

