% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdc_datacats.r
\name{ncdc_datacats}
\alias{ncdc_datacats}
\title{Get possible data categories for a particular datasetid, locationid,
stationid, etc.}
\usage{
ncdc_datacats(datasetid = NULL, datacategoryid = NULL,
  stationid = NULL, locationid = NULL, startdate = NULL,
  enddate = NULL, sortfield = NULL, sortorder = NULL, limit = 25,
  offset = NULL, token = NULL, ...)
}
\arguments{
\item{datasetid}{Accepts a valid dataset id or a vector or list of dataset id's. Data returned
will be from the dataset specified, see datasets() (required)}

\item{datacategoryid}{A valid data category id. Data types returned will be associated
with the data category(ies) specified}

\item{stationid}{Accepts a valid station id or a vector or list of station ids (optional)}

\item{locationid}{Accepts a valid location id or a vector or list of location id's. (optional)}

\item{startdate}{Accepts valid ISO formated date (yyyy-mm-dd). Data returned will have
data after the specified date. Paramater can be use independently of enddate (optional)}

\item{enddate}{Accepts valid ISO formated date (yyyy-mm-dd). Data returned will have data
before the specified date. Paramater can be use independently of startdate (optional)}

\item{sortfield}{The field to sort results by. Supports id, name, mindate, maxdate, and
datacoverage fields (optional)}

\item{sortorder}{Which order to sort by, asc or desc. Defaults to asc (optional)}

\item{limit}{Defaults to 25, limits the number of results in the response. Maximum is
1000 (optional)}

\item{offset}{Defaults to 0, used to offset the resultlist (optional)}

\item{token}{This must be a valid token token supplied to you by NCDC's
Climate Data Online access token generator. (required) See
\strong{Authentication} section below for more details.}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
A \code{data.frame} for all datasets, or a list of length two,
each with a data.frame.
}
\description{
Data Categories represent groupings of data types.
}
\details{
Note that calls with both startdate and enddate don't seem to
work, though specifying one or the other mostly works.
}
\section{Authentication}{

Get an API key (aka, token) at \url{http://www.ncdc.noaa.gov/cdo-web/token}.
You can pass your token in as an argument or store it one of two places:

\itemize{
\item your .Rprofile file with an entry like
\code{options(noaakey = "your-noaa-token")}
\item your .Renviron file with an entry like
\code{NOAA_KEY=your-noaa-token}
}

See \code{\link{Startup}} for information on how to create/find your
.Rrofile and .Renviron files
}

\examples{
\dontrun{
## Limit to 10 results
ncdc_datacats(limit=10)

## by datasetid
ncdc_datacats(datasetid="ANNUAL")
ncdc_datacats(datasetid=c("ANNUAL", "PRECIP_HLY"))

## Single data category
ncdc_datacats(datacategoryid="ANNAGR")

## Fetch data categories for a given set of locations
ncdc_datacats(locationid='CITY:US390029')
ncdc_datacats(locationid=c('CITY:US390029', 'FIPS:37'))

## Data categories for a given date
ncdc_datacats(startdate = '2013-10-01')

# Get data categories with data for a series of the same parameter arg, in this case
# stationid's
ncdc_datacats(stationid='COOP:310090')
ncdc_datacats(stationid=c('COOP:310090','COOP:310184','COOP:310212'))

## Curl debugging
ncdc_datacats(limit=10, verbose = TRUE)
}
}
\references{
Vignette at \url{http://ropensci.org/tutorials/rnoaa_tutorial.html}

\url{https://www.ncdc.noaa.gov/cdo-web/webservices/v2}
}
\seealso{
Other ncdc: \code{\link{ncdc_combine}},
  \code{\link{ncdc_datasets}},
  \code{\link{ncdc_datatypes}},
  \code{\link{ncdc_locs_cats}}, \code{\link{ncdc_locs}},
  \code{\link{ncdc_plot}}, \code{\link{ncdc_stations}},
  \code{\link{ncdc}}
}
\concept{ncdc}
