% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seaice_tabular.R
\name{sea_ice_tabular}
\alias{sea_ice_tabular}
\title{Sea ice tabular data}
\usage{
sea_ice_tabular(...)
}
\arguments{
\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET} - beware
that curl options are passed to each http request, for each of
24 requests.}
}
\value{
A data.frame with columns:
\itemize{
\item year (integer)
\item mo (integer)
\item data.type (character)
\item region (character)
\item extent (numeric)
\item area (numeric)
}
}
\description{
Collects \code{.csv} files from NOAA, and binds them together into
a single data.frame. Data across years, with extent and area of ice.
}
\details{
An example file, for January, North pole:
\verb{ftp://sidads.colorado.edu/DATASETS/NOAA/G02135/north/monthly/data/N_01_extent_v3.0.csv}

a value in any cell of -9999 indicates missing data
}
\examples{
\dontrun{
df <- sea_ice_tabular()
df
}
}
\seealso{
\code{\link[=sea_ice]{sea_ice()}}
}
