% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSGparse.R
\name{OSGparse}
\alias{OSGparse}
\title{Converts OS Grid Reference to BNG/WGS coordinates.}
\usage{
OSGparse(gridRefs, CoordSystem = "NG")
}
\arguments{
\item{gridRefs}{This is a string (or a vector of strings) that expresses the UK Grid Reference.}

\item{CoordSystem}{This is "NG" (British/Irish National Grid) by default. If you want lat/lon, use CoordSystem = "WGS84" (more info can be found here https://www.epsg-registry.org/).}
}
\value{
vector made of two elements: the easting and northing (by default) or Lat and Lon coordinates.
}
\description{
This function converts an OS reference to easting/northing coordinates (UK National Grid, epsg:27700).
}
\examples{
# single entry
OSGparse(gridRefs="TQ722213")

# multiple entries
OSGparse(gridRefs=c("SN831869","SN829838"))

}
\author{
Claudia Vitolo
}

