% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabCoord.R
\name{tabCoord}
\alias{tabCoord}
\alias{tabCoordWrapper}
\title{Coordinate representation of compositional tables and a sample of compositional tables}
\usage{
tabCoord(x = NULL, row.factor = NULL, col.factor = NULL,
  value = NULL, SBPr = NULL, SBPc = NULL, pivot = FALSE,
  print.res = FALSE)

tabCoordWrapper(X, obs.ID = NULL, row.factor = NULL,
  col.factor = NULL, value = NULL, SBPr = NULL, SBPc = NULL,
  pivot = FALSE, test = FALSE, n.boot = 1000)
}
\arguments{
\item{x}{a data frame containing variables representing row and column factors of the respective compositional table and variable with the values of the composition.}

\item{row.factor}{name of the variable representing the row factor. Needs to be stated with the quotation marks.}

\item{col.factor}{name of the variable representing the column factor. Needs to be stated with the quotation marks.}

\item{value}{name of the variable representing the values of the composition. Needs to be stated with the quotation marks.}

\item{SBPr}{an \eqn{I-1\times I} array defining the sequential binary partition of the values of the row factor, where I is the number of the row factor levels. The values assigned in the given step to the + group are marked by 1, values from  the - group by -1 and the rest by 0. If it is not provided, the pivot version of coordinates is constructed automatically.}

\item{SBPc}{an \eqn{J-1\times J} array defining the sequential binary partition of the values of the column factor, where J is the number of the column factor levels. The values assigned in the given step to the + group are marked by 1, values from  the - group by -1 and the rest by 0. If it is not provided, the pivot version of coordinates is constructed automatically.}

\item{pivot}{logical, default is FALSE. If TRUE, or one of the SBPs is not defined, its pivot version is used.}

\item{print.res}{logical, default is FALSE. If TRUE, the output is displayed in the Console.}

\item{X}{a data frame containing variables representing row and column factors of the respective compositional tables, variable with the values 
of the composition and variable distinguishing the observations.}

\item{obs.ID}{name of the variable distinguishing the observations. Needs to be stated with the quotation marks.}

\item{test}{logical, default is \code{FALSE}. If \code{TRUE}, the bootstrap analysis of coordinates is provided.}

\item{n.boot}{number of bootstrap samples.}
}
\value{
\item{Coordinates}{an array of orthonormal coordinates.}
\item{Grap.rep}{graphical representation of the coordinates. Parts denoted by \verb{+} form the groups in the numerator of the respective computational formula, parts \verb{-} form the denominator and parts \verb{.} are not involved in the given coordinate.}
\item{Ind.coord}{an array of row and column balances. Coordinate representation of the independent part of the table.}
\item{Int.coord}{an array of OR coordinates. Coordinate representation of the interactive part of the table.}
\item{Contrast.matrix}{contrast matrix.}
\item{Log.ratios}{an array of pure log-ratios between groups of parts without the normalizing constant.}
\item{Coda.table}{table form of the given composition.}
\item{Bootstrap}{array of sample means, standard deviations and bootstrap confidence intervals.}
\item{Tables}{Table form of the given compositions.}
}
\description{
tabCoord computes a system of orthonormal coordinates of a compositional table. 
Computation of either pivot coordinates or a coordinate system based on the given SBP is possible.

tabCoordWrapper: For each compositional table in the sample \code{tabCoordWrapper} 
computes a system of orthonormal coordinates and provide a simple descriptive analysis. 
Computation of either pivot coordinates or a coordinate system based on the given SBP is possible.
}
\details{
tabCoord

This transformation moves the IJ-part compositional tables 
from the simplex into a (IJ-1)-dimensional real space isometrically 
with respect to its two-factorial nature. 
The coordinate system is formed by two types of coordinates - balances and log odds-ratios.

tabCoordWrapper: Each of n IJ-part compositional tables from the sample is with 
respect to its two-factorial nature isometrically transformed from the simplex 
into a (IJ-1)-dimensional real space. Sample mean values and standard deviations are 
computed and using bootstrap an estimate of 95 \% confidence interval is given.
}
\examples{
###################
### Coordinate representation of a CoDa Table

# example from Fa\\v cevicov\\'a (2018):
data(manu_abs)
manu_USA <- manu_abs[which(manu_abs$country=='USA'),]
manu_USA$output <- factor(manu_USA$output, levels=c('LAB', 'SUR', 'INP'))

# pivot coordinates
tabCoord(manu_USA, row.factor = 'output', col.factor = 'isic', value='value')

# SBPs defined in paper
r <- rbind(c(-1,-1,1), c(-1,1,0))
c <- rbind(c(-1,-1,-1,-1,1), c(-1,-1,-1,1,0), c(-1,-1,1,0,0), c(-1,1,0,0,0))
tabCoord(manu_USA, row.factor = 'output', col.factor = 'isic', value='value', SBPr=r, SBPc=c)

###################
### Analysis of a sample of CoDa Tables

# example from Fa\\v cevicov\\'a (2018):
data(manu_abs)

### Compositional tables approach,
### analysis of the relative structure.
### An example from Facevi\\v cov\\'a (2018)

manu_abs$output <- factor(manu_abs$output, levels=c('LAB', 'SUR', 'INP'))

# pivot coordinates
tabCoordWrapper(manu_abs, obs.ID='country',
row.factor = 'output', col.factor = 'isic', value='value')

# SBPs defined in paper
r <- rbind(c(-1,-1,1), c(-1,1,0))
c <- rbind(c(-1,-1,-1,-1,1), c(-1,-1,-1,1,0), 
c(-1,-1,1,0,0), c(-1,1,0,0,0))
tabCoordWrapper(manu_abs, obs.ID='country',row.factor = 'output', 
col.factor = 'isic', value='value', SBPr=r, SBPc=c, test=TRUE)

### Classical approach,
### generalized linear mixed effect model.

\dontrun{
library(lme4)
glmer(value~output*as.factor(isic)+(1|country),data=manu_abs,family=poisson)
}
}
\references{
Facevicova, K., Hron, K., Todorov, V. and M. Templ (2018) 
General approach to coordinate representation of compositional tables. 
Scandinavian Journal of Statistics, 45(4), 879--899.
}
\seealso{
\code{\link{cubeCoord}} 
\code{\link{cubeCoordWrapper}}
}
\author{
Kamila Facevicova
}
\keyword{coordinates}
\keyword{multivariate,}
