% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robets.R
\name{robets}
\alias{robets}
\title{Robust exponential smoothing model}
\usage{
robets(y, model = "ZZZ", damped = NULL, alpha = NULL, beta = NULL,
  gamma = NULL, phi = NULL, additive.only = FALSE, lambda = NULL,
  lower = c(rep(1e-04, 3), 0.8), upper = c(rep(0.9999, 3), 0.98),
  opt.crit = c("tau2", "roblik", "lik", "mse", "amse", "sigma", "mae"),
  bounds = c("both", "usual", "admissible"), ic = c("robaicc", "robaic",
  "robbic", "aicc", "bic", "aic"), use.initial.values = FALSE,
  opt.initial.values = FALSE, rob.start.initial.values = TRUE,
  opt.sigma0 = FALSE, k = 3, nmse = 1, ...)
}
\arguments{
\item{y}{a numeric vector or time series}

\item{model}{A three-letter string indicating the method using the framework terminology of Hyndman et al. (2008). The first letter denotes the error type ("A", "M" or "Z"); the second letter denotes the trend type ("N","A" or "Z"); and the third letter denotes the season type ("N","A","M" or "Z"). In all cases, "N"=none, "A"=additive, "M"=multiplicative and "Z"=automatically selected. So, for example, "ANN" is simple exponential  smoothing with additive errors, "MAM" is multiplicative Holt-Winters' method with multiplicative errors, and so on. It is also possible for the model to be of class "\code{robets}", and equal to the output from a previous call to \code{robets}. In this case, the same model is fitted to \code{y} without re-estimating any smoothing parameters. See also the \code{use.initial.values} argument.}

\item{damped}{If TRUE, use a damped trend. If NULL, both damped and non-damped trends will be tried and the best model (according to the information criterion \code{ic}) will be returned.}

\item{alpha}{Value of alpha. If NULL, it is estimated.}

\item{beta}{Value of beta. If NULL, it is estimated.}

\item{gamma}{Value of gamma. If NULL, it is estimated.}

\item{phi}{Value of phi. If NULL, it is estimated.}

\item{additive.only}{If TRUE, will only consider additive models. Default is FALSE.}

\item{lambda}{Box-Cox transformation parameter. Ignored if NULL. Otherwise, data transformed before model is estimated. When \code{lambda=TRUE}, \code{additive.only} is set to FALSE.}

\item{lower}{Lower bounds for the parameters (alpha, beta, gamma, phi)}

\item{upper}{Upper bounds for the parameters (alpha, beta, gamma, phi)}

\item{opt.crit}{Optimization criterion. One of "\link{tau2}" (Tau squared error of the residuals, default), "roblik" (Robust Log-likelihood), "mse" (Mean Square Error), "amse" (Average MSE over first \code{nmse} forecast horizons), "sigma" (Standard deviation of residuals), "mae" (Mean of absolute residuals), or "lik" (Log-likelihood).}

\item{bounds}{Type of parameter space to impose: \code{"usual"} indicates all parameters must lie between specified lower and upper bounds; \code{"admissible"} indicates parameters must lie in the admissible space; \code{"both"} (default) takes the intersection of these regions.}

\item{ic}{Information criterion to be used in model selection.}

\item{use.initial.values}{If \code{TRUE} and \code{model} is of class \code{"robets"}, then the initial values in the model are also not re-estimated.}

\item{opt.initial.values}{If \code{FALSE} (default) a robust heuristic is used for chosing the initial values. If \code{TRUE}  the initial values are part of the problem to optimize \code{opt.crit}.  Neglected if \code{use.initial.values} is \code{TRUE} and \code{model} is of class \code{"robets"}.}

\item{rob.start.initial.values}{If \code{TRUE} (default) the initial values are computed via the robust heuristic described in Crevits and Croux (2016). If \code{FALSE} the initial values are computed via the same heuristic as in Hyndman et al. (2008). The initial values computed with these methods are further optimized if \code{opt.initial.values} is \code{TRUE}.}

\item{opt.sigma0}{If \code{FALSE} (default) sigma0 is equal to the value computed together with the other initial values via a heuristic. If \code{TRUE} sigma0 is included as a variable in the optimization problem. It is not recommended to set \code{opt.sigma0 = TRUE}.}

\item{k}{Value of k in forecasting equations. \code{k=3} is default. If NULL, \code{k} is included as a variable in the optimization problem. It is not recommended to set \code{k = NULL}.}

\item{nmse}{Number of steps for AMSE (1<=\code{nmse}<=30), \code{nmse=1} is default.}

\item{...}{Other undocumented arguments.}
}
\value{
An object of class "\code{robets}".
}
\description{
Returns robets model applied to \code{y}.
}
\details{
The code is an extended version of the code of the function \code{ets} of the package \code{forecast} of Hyndman and Khandakar (2008). The methodology is an extended version of Gelper et al. (2008). In Crevits and Croux (2016) the methodology of \code{robets} is described in full (\url{https://rcrevits.wordpress.com/research}).
}
\examples{
library(forecast)
model <- robets(nottem)
plot(forecast(model))
}
\author{
Ruben Crevits, \email{ruben.crevits@kuleuven.be}
}
\references{
Crevits, R., and Croux, C (2016) "Robust Exponential Smoothing".\emph{Working paper}.

Gelper S., Fried R. and Croux C. (2010) "Robust Forecasting with Exponential and Holt-Winters Smoothing".\emph{Journal of Forecasting}, \strong{29}, 285-300.

Hyndman, R. J., and Khandakar, Y (2008) "Automatic time series forecasting: The forecasting package for R".\emph{Journal of Statistical Software} \strong{27}(3).
}
\seealso{
\code{\link{forecast.robets}, \link{plot.robets}, \link{plotOutliers}, \link{tau2}, \link{ets}}
}

