% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permDistribution.R
\name{m_est_perm_distribution}
\alias{m_est_perm_distribution}
\title{Permutation distribution for M-statistics}
\usage{
m_est_perm_distribution(x, y, psi, k, randomization = FALSE, n.rep = 10000)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{a (non-empty) numeric vector of data values.}

\item{psi}{kernel used for optimization.
Must be one of \code{"bisquare"}, \code{"hampel"} and \code{"huber"}.
The default is \code{"huber"}.}

\item{k}{tuning parameter(s) for the respective kernel function,
defaults to parameters implemented in \code{\link[robustbase:lmrob.control]{.Mpsi.tuning.default(psi)}}
in the package \href{https://cran.r-project.org/package=robustbase}{robustbase}.}

\item{randomization}{a logical value indicating whether the p-value should be
computed from a permutation (\code{FALSE}, default) or a
randomization (\code{TRUE}) distribution.}

\item{n.rep}{an integer value specifying the number of random splits used to
calculate the randomization distribution if \code{method = "randomization"}.
The default is \code{n.rep = 10000}.}
}
\value{
Vector with permutation distribution of the test statistic specified by \code{psi}
        and \code{k}.
}
\description{
\code{mest_perm_distribution} calculates the permutation distribution for the M-statistics from
             \code{m_test_statistic}.
}
\details{
Missing values in either \code{x} or \code{y} are not allowed.
}
\references{
\insertRef{MaeRouCro20robu}{robnptests}
}
\keyword{internal}
