% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_to_txt.R
\name{doc_to_txt}
\alias{doc_to_txt}
\title{Convert a document (.docx, .pdf, etc) to a plain text file}
\usage{
doc_to_txt(
  input,
  output = NULL,
  encoding = rock::opts$get("encoding"),
  newExt = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  silent = rock::opts$get("silent"),
  skip = 0,
  remove.empty = TRUE,
  trim = TRUE,
  combine = FALSE,
  format = FALSE,
  ocr = TRUE,
  ...
)
}
\arguments{
\item{input}{The path to the input file.}

\item{output}{The path and filename to write to. If this is a path to
an existing directory (without a filename specified), the \code{input} filename
will be used, and the extension will be replaced with \code{extension}.}

\item{encoding}{The encoding to use when writing the text file.}

\item{newExt}{The extension to append: only used if \code{output = NULL} and
\code{newExt} is not \code{NULL}, in which case the output will be written to a file
with the same name as \code{input} but with \code{newExt} as extension.}

\item{preventOverwriting}{Whether to prevent overwriting existing files.}

\item{silent}{Whether to the silent or chatty.}

\item{skip}{The number of lines to skip (see \code{\link[textreadr:read_document]{textreadr::read_document()}}).}

\item{remove.empty}{If \code{TRUE} empty elements in the vector are
removed (see \code{\link[textreadr:read_document]{textreadr::read_document()}}).}

\item{trim}{If \code{TRUE} the leading/training white space is
removed (see \code{\link[textreadr:read_document]{textreadr::read_document()}}).}

\item{combine}{If \code{TRUE} the vector is concatenated into a single string
\code{textshape::combine()}. (see \code{\link[textreadr:read_document]{textreadr::read_document()}}).}

\item{format}{For .doc files only. Logical. If \code{TRUE} the output will keep
doc formatting (e.g., bold, italics, underlined). This corresponds to
the \code{-f} flag in antiword (see \code{\link[textreadr:read_document]{textreadr::read_document()}}).}

\item{ocr}{If \code{TRUE} .pdf documents with a non-text pull using
\code{pdftools::pdf_text()} will be re-run using OCR via the \code{tesseract::ocr()}
function. This will create temporary .png files and will require a much
larger compute time (see \code{\link[textreadr:read_document]{textreadr::read_document()}}).}

\item{...}{Other arguments passed to \code{\link[textreadr:read_pdf]{textreadr::read_pdf()}},
\code{\link[textreadr:read_html]{textreadr::read_html()}}, \code{\link[textreadr:read_docx]{textreadr::read_docx()}}, \code{\link[textreadr:read_doc]{textreadr::read_doc()}},
or \code{\link[base:readLines]{base::readLines()}} (by \code{\link[textreadr:read_document]{textreadr::read_document()}}).}
}
\value{
The converted source, as a character vector.
}
\description{
This is a thin wrapper around \code{\link[textreadr:read_document]{textreadr::read_document()}} that also
writed the result to \code{output}, doing its best to correctly write UTF-8
(based on the approach recommended in \href{https://tomizonor.wordpress.com/2013/04/17/file-utf8-windows/}{this blog post}).
}
\examples{
print(
  rock::doc_to_txt(
    input = system.file(
      "extdata/doc-to-test.docx", package="rock"
    )
  )
);
}
