% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rockchalk-package.R
\docType{package}
\name{rockchalk-package}
\alias{rockchalk-package}
\alias{rockchalk}
\title{rockchalk: regression functions}
\description{
Includes an ever-growing collection of functions that assist in
the presentation of regression models.  The initial function was
\code{\link{outreg}}, which produces LaTeX tables that summarize
one or many fitted regression models.  It also offers plotting
conveniences like \code{\link{plotPlane}} and
\code{\link{plotSlopes}}, which illustrate some of the variables
from a fitted regression model. For a detailed check on
multicollinearity, see \code{\link{mcDiagnose}}.  The user should
be aware of this fact: Not all of these functions lead to models
or types of analysis that we endorese.  Rather, they all lead to
analysis that is endorsed by some scholars, and we feel it is
important to facilitate the comparison of competing methods.  For
example, the function \code{\link{standardize}} will calculate
standardized regression coefficients for all predictors in a
regression model's design matrix in order to replicate results
from other statistical frameworks, no matter how unwise the use of
such coefficients might be. The function \code{\link{meanCenter}}
will allow the user to more selectively choose variables for
centering (and possibly standardization) before they are entered
into the design matrix.  Because of the importance of interaction
variables in regression analysis, the \code{\link{residualCenter}}
and \code{\link{meanCenter}} functions are offered.  While mean
centering does not actually help with multicollinearity of
interactive terms, many scholars have argued that it does.  The
meanCenter function can be compared with the "residual centering"
of interaction terms.
}
\references{
http://pj.freefaculty.org/R
}
\author{
Paul E. Johnson \email{pauljohn@ku.edu}
}
\keyword{hplot}
\keyword{regression}
