% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_query.R
\name{run_query}
\alias{run_query}
\alias{run_query.star_database}
\title{Run query}
\usage{
run_query(db, sq)

\method{run_query}{star_database}(db, sq)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{sq}{A \code{star_query} object.}
}
\value{
A \code{star_database} object.
}
\description{
Once we have selected the facts, dimensions and defined the conditions on the
instances, we can execute the query to obtain the result.
}
\details{
As an option, we can indicate if we do not want to unify the facts in the
case of having the same grain.
}
\examples{

sq <- mrs_db |>
  star_query() |>
  select_dimension(name = "where",
                   attributes = c("city", "state")) |>
  select_dimension(name = "when",
                   attributes = "year") |>
  select_fact(
    name = "mrs_age",
    measures = "all_deaths",
    agg_functions = "MAX"
  ) |>
  select_fact(
    name = "mrs_cause",
    measures = c("pneumonia_and_influenza_deaths", "all_deaths")
  ) |>
  filter_dimension(name = "when", week <= " 3") |>
  filter_dimension(name = "where", city == "Bridgeport")

mrs_db_2 <- mrs_db |>
  run_query(sq)

}
\seealso{
Other query functions: 
\code{\link{filter_dimension}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()},
\code{\link{star_query}()}
}
\concept{query functions}
