% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_regres.R
\name{roll_regres}
\alias{roll_regres}
\title{Fitting Rolling and Expanding Linear Models}
\usage{
roll_regres(formula, data, width, contrasts = NULL,
  do_compute = character(), grp = NULL, do_downdates = TRUE,
  min_obs = NULL)
}
\arguments{
\item{formula}{as \code{formula} in \code{\link{lm}}.}

\item{data}{an optional \code{data.frame} containing the variables in the model.}

\item{width}{integer with the width of the moving window. Only used if
\code{do_downdates == TRUE}.}

\item{contrasts}{list passed to \code{\link{model.matrix.default}}s
\code{contrasts.arg} argument.}

\item{do_compute}{character vector with elements \code{"sigmas"},
\code{"r.squareds"}, and/or \code{"1_step_forecasts"} for additional output
to be computed. See "Details" in \code{\link{roll_regres}}.}

\item{grp}{integer vector to be used if you e.g., want to run the regression
over weekly blocks of data. See "Details" in \code{\link{roll_regres}}.}

\item{do_downdates}{logical which is \code{TRUE} if you want a rolling
window regressions. Otherwise, an expanding window is used.}

\item{min_obs}{positive integer with minimum number of observation that are
required in a window. Useful if there are gaps in \code{grp} or unequal
number of observations for each \code{grp}.}
}
\value{
List with vector and matrices with the computed output. See the
\code{do_compute} argument.
}
\description{
Method for fast rolling and expanding regression models. I.e.,
linear models estimated over a moving window or expanding window of data.
The function assumes that data is ordered.
}
\details{
\code{do_compute} can contain \code{"sigmas"} if you want the estimated
standard deviation of the residuals, \code{"r.squareds"} for the \eqn{R^2}
of the models, and \code{"1_step_forecasts"} for the out-of-sample forecast
for the next periods value.

\code{grp} is a sorted integer vector if you want to make "block" updates.
E.g., \code{grp} could be an integer vector with the week number. The
\code{width} argument is relative to the \code{grp} argument if the
\code{grp} argument is not \code{NULL}. The indices of \code{grp} should
match with the other data objects.

See \code{vignette("Comparisons", package = "rollRegres")} for further
examples.
}
\examples{
# simulate data
set.seed(29132867)
n <- 50
p <- 2
X <- cbind(1, matrix(rnorm(p * n), ncol = p))
y <- drop(X \%*\% c(1, -1, 1)) + rnorm(n)
df <- data.frame(y, X[, -1])

# compute coefs
out <- roll_regres(y ~ X1 + X2, df, width = 45L)
tail(out$coefs)

# compute more output
out <- roll_regres(
 y ~ X1 + X2, df, width = 45L,
 do_compute = c("sigmas", "r.squareds", "1_step_forecasts"))
lapply(out, tail)

}
\seealso{
\code{\link{roll_regres.fit}} for method that avoids the call to
e.g., \code{\link{model.frame}}.
}
