% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_grid_ahull_fill.R
\name{build_grid_ahull_fill}
\alias{build_grid_ahull_fill}
\title{Regular grid in alpha-hull}
\usage{
build_grid_ahull_fill(coords, npts, pad = NULL, grid_opts = list(alpha =
  0.3, error_tol = 0.05, run_max = 20, verbose = FALSE))
}
\arguments{
\item{coords}{A matrix or data.frame of coordinates with two columns}

\item{npts}{The approximate number of points of the requested grid}

\item{pad}{ignored.}

\item{grid_opts}{A list with component \code{alpha} that controls the
                    shape of the alpha hull, \code{error_tol} the error
                    tolerance as a fraction of the number of points,
                    \code{run_max} the maximum number of iterations and
                    \code{verbose} to get some debug output.}
}
\value{
The coordinates of a grid of points as a \code{data.frame} with
        approximately \code{npts} rows and \code{ncol(coords)} columns. Names
        are transfered from the \code{coords} data frame.
}
\description{
Create a grid within the alpha hull of a set of points.
}
\details{


This function computes the alpha hull of a set of points, then
         iteratively finds the best grid of \code{npts} points fitting in the hull.
}
\seealso{
Other grid.building.functions: \code{\link{build_grid_ahull_crop}};
  \code{\link{build_grid_identical}};
  \code{\link{build_grid_squaretile}}
}

