% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_heatmap.R
\name{hclust_order}
\alias{hclust_order}
\title{Hierarchical clustering order}
\usage{
hclust_order(
  df,
  feature_pk,
  sample_pk,
  value_var,
  cluster_dim,
  distance_measure = "dist",
  hclust_method = "ward.D2"
)
}
\arguments{
\item{df}{data.frame to cluster}

\item{feature_pk}{variable uniquely defining a row}

\item{sample_pk}{variable uniquely definining a sample}

\item{value_var}{An abundance value to use with \code{hclust}}

\item{cluster_dim}{rows, columns, or both}

\item{distance_measure}{variable to use for computing dis-similarity
\describe{
  \item{corr}{pearson correlation}
  \item{dist}{euclidean distance}
}}

\item{hclust_method}{method from stats::hclust to use for clustering}
}
\value{
a list containing a hierarchically clustered set of rows and/or
  columns
}
\description{
Format and hierarchically cluster a data.frame. If hclust could not normally
  be produced (usually because no samples are in common for a feature) pad
  the matrix with zeros and still calculate the distance
}
\examples{

library(dplyr)

df <- tidyr::crossing(letters = LETTERS, numbers = 1:10) \%>\%
  mutate(noise = rnorm(n()))
hclust_order(df, "letters", "numbers", "noise", "rows")
}
