% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shorthand.R
\name{chr}
\alias{chr}
\alias{int}
\alias{dbl}
\alias{num}
\alias{bool}
\alias{as.class}
\title{Cleaner conversion functions}
\usage{
chr(x, ...)

int(x, ...)

dbl(x, ...)

num(x, ...)

bool(x, ...)

as.class(x, class)
}
\arguments{
\item{x}{object to be converted}

\item{...}{other args for as. conversion}

\item{class}{chatracter name of the class to convert x to}
}
\description{
Cleaner conversion functions

convert x to arbitrary class
}
\note{
These are shorthand aliases for common conversions There is nothing magical
here, but it can make your code more readable
}
\examples{
chr(42)   # "42" = as.character
int(42.1) # 42L  = as.integer
dbl("42L") # 42.0 = as.double
num("42") # 42   = as.numeric
bool(42)  # TRUE = as.logical


foo <- 255
as.class(foo, "roman")
# [1] CCLV
}
\author{
Steven Nydick, \email{steven.nydick@kornferry.com}

Ben Wiseman, \email{benjamin.wiseman@kornferry.com}

Ben Wiseman, \email{benjamin.wiseman@kornferry.com}

Ben Wiseman, \email{benjamin.wiseman@kornferry.com}
}
