/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.libror;

import fi.smaa.libror.InfeasibleConstraintsException;
import fi.smaa.libror.LinearConstraintHelper;
import fi.smaa.libror.RORModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.LinearConstraint;
import org.apache.commons.math.optimization.linear.LinearObjectiveFunction;
import org.apache.commons.math.optimization.linear.NoFeasibleSolutionException;
import org.apache.commons.math.optimization.linear.Relationship;
import org.apache.commons.math.optimization.linear.SimplexSolver;

public class UTAGMSSolver
extends RORModel {
    private RealMatrix necessaryRelation = null;
    private RealMatrix possibleRelation = null;
    private SimplexSolver solver = new SimplexSolver();
    private boolean strictValueFunctions = false;
    private static final int MAX_SIMPLEX_ITERATIONS = 100000;
    private static final double MIN_EPSILON = 1.0E-5;

    public UTAGMSSolver(RealMatrix perfMatrix) {
        super(perfMatrix);
        this.solver.setMaxIterations(100000);
    }

    public void solve() throws InfeasibleConstraintsException {
        this.solve(RelationsType.BOTH);
    }

    public void solve(RelationsType rel) throws InfeasibleConstraintsException {
        this.necessaryRelation = new Array2DRowRealMatrix(this.getNrAlternatives(), this.getNrAlternatives());
        this.possibleRelation = new Array2DRowRealMatrix(this.getNrAlternatives(), this.getNrAlternatives());
        List<LinearConstraint> baseConstraints = this.buildRORConstraints();
        try {
            RealPointValuePair res = this.solver.optimize(this.buildObjectiveFunction(), baseConstraints, GoalType.MAXIMIZE, true);
            if (res.getValue() <= 0.0) {
                throw new InfeasibleConstraintsException("Preference information leading to infeasible constraints, epsilon <= 0.0");
            }
        }
        catch (OptimizationException e) {
            throw new InfeasibleConstraintsException("Preference information leading to infeasible constraints: " + e.getMessage());
        }
        for (int i = 0; i < this.getNrAlternatives(); ++i) {
            for (int j = 0; j < this.getNrAlternatives(); ++j) {
                boolean necHolds = false;
                if (rel.equals((Object)RelationsType.NECESSARY) || rel.equals((Object)RelationsType.BOTH)) {
                    necHolds = this.solveRelation(i, j, baseConstraints, true);
                    this.necessaryRelation.setEntry(i, j, necHolds ? 1.0 : 0.0);
                }
                if (!rel.equals((Object)RelationsType.POSSIBLE) && !rel.equals((Object)RelationsType.BOTH)) continue;
                if (necHolds) {
                    this.possibleRelation.setEntry(i, j, 1.0);
                    continue;
                }
                this.possibleRelation.setEntry(i, j, this.solveRelation(i, j, baseConstraints, false) ? 1.0 : 0.0);
            }
        }
    }

    public void printModel(boolean necessary, int a, int b) {
        List<LinearConstraint> constraints = this.buildRORConstraints();
        this.addNecOrPrefConstraint(a, b, necessary, constraints);
        LinearConstraintHelper.printConstraints(constraints);
    }

    List<LinearConstraint> buildRORConstraints() {
        int i;
        ArrayList<LinearConstraint> c = new ArrayList<LinearConstraint>();
        for (RORModel.PrefPair p : this.prefPairs) {
            c.add(this.buildStrictlyPreferredConstraint(p.a, p.b));
        }
        for (i = 0; i < this.getNrCriteria(); ++i) {
            c.addAll(this.buildMonotonousConstraints(i));
        }
        for (i = 0; i < this.getNrCriteria(); ++i) {
            c.add(this.buildFirstLevelZeroConstraint(i));
        }
        c.add(this.buildBestLevelsAddToUnityConstraint());
        c.addAll(this.buildAllVariablesLessThan1Constraint());
        c.add(this.buildEpsilonStrictlyPositiveConstraint());
        return c;
    }

    private LinearConstraint buildEpsilonStrictlyPositiveConstraint() {
        double[] lhsVars = new double[this.getNrLPVariables()];
        lhsVars[lhsVars.length - 1] = 1.0;
        return new LinearConstraint(lhsVars, Relationship.GEQ, 1.0E-5);
    }

    private List<LinearConstraint> buildAllVariablesLessThan1Constraint() {
        ArrayList<LinearConstraint> con = new ArrayList<LinearConstraint>();
        for (int i = 0; i < this.getNrLPVariables(); ++i) {
            double[] lhsVars = new double[this.getNrLPVariables()];
            lhsVars[i] = 1.0;
            con.add(new LinearConstraint(lhsVars, Relationship.LEQ, 1.0));
        }
        return con;
    }

    private LinearConstraint buildBestLevelsAddToUnityConstraint() {
        double[] vars = new double[this.getNrLPVariables()];
        for (int i = 0; i < this.getNrCriteria(); ++i) {
            vars[this.getConstraintOffset((int)i) + this.getLevels()[i].getDimension() - 1] = 1.0;
        }
        return new LinearConstraint(vars, Relationship.EQ, 1.0);
    }

    private LinearConstraint buildFirstLevelZeroConstraint(int critIndex) {
        double[] lhsVars = new double[this.getNrLPVariables()];
        lhsVars[this.getConstraintOffset((int)critIndex)] = 1.0;
        return new LinearConstraint(lhsVars, Relationship.EQ, 0.0);
    }

    private List<LinearConstraint> buildMonotonousConstraints(int critIndex) {
        ArrayList<LinearConstraint> constList = new ArrayList<LinearConstraint>();
        RealVector levels = this.getLevels()[critIndex];
        for (int i = 0; i < levels.getDimension() - 1; ++i) {
            double[] lhs = new double[this.getNrLPVariables()];
            double[] rhs = new double[this.getNrLPVariables()];
            lhs[this.getConstraintOffset((int)critIndex) + i] = 1.0;
            rhs[this.getConstraintOffset((int)critIndex) + i + 1] = 1.0;
            if (this.strictValueFunctions) {
                lhs[lhs.length - 1] = 1.0;
            }
            constList.add(new LinearConstraint(lhs, 0.0, Relationship.LEQ, rhs, 0.0));
        }
        return constList;
    }

    private LinearConstraint buildStrictlyPreferredConstraint(int a, int b) {
        double[] lhsVars = new double[this.getNrLPVariables()];
        double[] rhsVars = new double[this.getNrLPVariables()];
        this.setVarsPositive(lhsVars, a);
        this.setVarsPositive(rhsVars, b);
        rhsVars[rhsVars.length - 1] = 1.0;
        return new LinearConstraint(lhsVars, 0.0, Relationship.GEQ, rhsVars, 0.0);
    }

    private void setVarsPositive(double[] vars, int altIndex) {
        for (int i = 0; i < this.getNrCriteria(); ++i) {
            vars[this.getConstraintIndex((int)i, (int)altIndex)] = 1.0;
        }
    }

    private int getNrLPVariables() {
        int sum = 0;
        for (RealVector vec : this.getLevels()) {
            sum += vec.getDimension();
        }
        return sum + 1;
    }

    private int getConstraintIndex(int critIndex, int altIndex) {
        assert (critIndex >= 0 && altIndex >= 0);
        int offset = this.getConstraintOffset(critIndex);
        int index = Arrays.binarySearch(this.getLevels()[critIndex].getData(), this.perfMatrix.getEntry(altIndex, critIndex));
        assert (index >= 0);
        return offset + index;
    }

    private int getConstraintOffset(int critIndex) {
        int offset = 0;
        for (int i = 0; i < critIndex; ++i) {
            offset += this.getLevels()[i].getDimension();
        }
        return offset;
    }

    private boolean solveRelation(int i, int j, List<LinearConstraint> rorConstraints, boolean necessary) {
        assert (i >= 0 && j >= 0);
        if (i == j) {
            return true;
        }
        ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>(rorConstraints);
        this.addNecOrPrefConstraint(i, j, necessary, constraints);
        LinearObjectiveFunction goalFunction = this.buildObjectiveFunction();
        try {
            RealPointValuePair res = this.solver.optimize(goalFunction, constraints, GoalType.MAXIMIZE, true);
            if (necessary) {
                return res.getValue() <= 0.0;
            }
            return res.getValue() > 0.0;
        }
        catch (NoFeasibleSolutionException e) {
            return necessary;
        }
        catch (OptimizationException e) {
            throw new IllegalStateException("Invalid OptimizationException: " + e.getMessage());
        }
    }

    private LinearObjectiveFunction buildObjectiveFunction() {
        double[] coeff = new double[this.getNrLPVariables()];
        coeff[coeff.length - 1] = 1.0;
        LinearObjectiveFunction goalFunction = new LinearObjectiveFunction(coeff, 0.0);
        return goalFunction;
    }

    private void addNecOrPrefConstraint(int i, int j, boolean necessary, List<LinearConstraint> constraints) {
        if (necessary) {
            constraints.add(this.buildStrictlyPreferredConstraint(j, i));
        } else {
            constraints.add(this.buildWeaklyPreferredConstraint(i, j));
        }
    }

    private LinearConstraint buildWeaklyPreferredConstraint(int a, int b) {
        double[] lhsVars = new double[this.getNrLPVariables()];
        double[] rhsVars = new double[this.getNrLPVariables()];
        this.setVarsPositive(lhsVars, a);
        this.setVarsPositive(rhsVars, b);
        return new LinearConstraint(lhsVars, 0.0, Relationship.GEQ, rhsVars, 0.0);
    }

    public RealMatrix getNecessaryRelation() throws IllegalStateException {
        if (this.necessaryRelation == null) {
            throw new IllegalStateException("violating PRECOND");
        }
        return this.necessaryRelation;
    }

    public RealMatrix getPossibleRelation() {
        if (this.possibleRelation == null) {
            throw new IllegalStateException("violating PRECOND");
        }
        return this.possibleRelation;
    }

    public void setStrictValueFunctions(boolean b) {
        this.strictValueFunctions = b;
    }

    public static enum RelationsType {
        BOTH,
        NECESSARY,
        POSSIBLE;

    }
}

