\name{prentice}
\alias{prentice}
\alias{prentice.Q4}
\alias{prentice.SO3}
\title{Transformation based asymptotic confidence region}
\usage{
  prentice(x, alp)

  \method{prentice}{Q4} (x, alp = NULL)

  \method{prentice}{SO3} (x, alp = NULL)
}
\arguments{
  \item{x}{\eqn{n\times p}{n-by-p} matrix where each row
  corresponds to a random rotation in matrix (\eqn{p=9}) or
  quaternion (\eqn{p=4}) form.}

  \item{alp}{alpha level desired, e.g. 0.05 or 0.10.}
}
\value{
  Radius of the confidence region centered at the projected
  mean for each of the x-, y- and z-axes.
}
\description{
  Find the radius of a \eqn{100(1-\alpha)}\% confidence
  region for the projected mean based on a result from
  directional statistics.
}
\details{
  Compute the radius of a \eqn{100(1-\alpha)}\% confidence
  region for the central orientation based on the projected
  mean estimator using the method due to \cite{Prentice
  (1986)}.  For a rotation specific version see
  \cite{Rancourt et al. (2000)}. The variability in each
  axis is different so each axis will have its own radius.
}
\examples{
Qs<-ruars(20, rcayley, kappa = 100, space = 'Q4')

#The prentice method can be accesed from the "region" function or the "prentice" function
region(Qs, method = "transformation", type = "asymptotic", alp = 0.1, estimator = "mean")
prentice(Qs, alp = 0.1)
}
\references{
  Prentice M (1986). "Orientation statistics without
  parametric assumptions." Journal of the Royal
  Statistical Society. Series B (Methodological), 48(2),
  pp. 214-222.

  Rancourt D, Rivest L and Asselin J (2000). "Using
  orientation statistics to investigate variations in human
  kinematics." Journal of the Royal Statistical Society:
  Series C (Applied Statistics), 49(1), pp. 81-94.
}
\seealso{
  \code{\link{bayesCR}}, \code{\link{fisheretal}},
  \code{\link{chang}}, \code{\link{zhang}}
}

