% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{taxonomy_subtree}
\alias{taxonomy_subtree}
\title{Taxonomy subtree}
\usage{
taxonomy_subtree(ott_id = NULL, output_format = c("taxa", "newick", "phylo",
  "raw"), file, ...)
}
\arguments{
\item{ott_id}{The ott id of the taxon of interest.}

\item{output_format}{the format of the object to be returned. See
the \sQuote{Return} section.}

\item{file}{the file name where to save the output of the
function. Ignored unless \code{output_format} is set to
\dQuote{\code{phylo}}.}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}
}
\value{
If the \code{file} argument is missing: \itemize{

    \item{\dQuote{\code{taxa}}} { a list of the taxa names
    (species) in slot \code{tip_label}, and higher-level taxanomy
    (e.g., families, genera) in slot \code{edge_label}, descending
    from the taxa corresponding to the \code{ott_id} provided. }

    \item{\dQuote{\code{newick}}} { a character vector containing
    the newick formatted string corresponding to the taxonomic
    subtree for the \code{ott_id} provided. }

    \item{\dQuote{\code{phylo}}} { an object of the class
    \code{phylo} from the \code{\link[ape]{ape}} package. }

    \item{\dQuote{\code{raw}}} { the direct output from the API,
    i.e., a list with an element named \sQuote{subtree} that
    contains the subtree as a newick formatted string. }

    }

    If a \code{file} argument is provided (and
    \code{output_format} is set to \dQuote{\code{phylo}}), a
    logical indicating whether the file was successfully created.
}
\description{
Given an ott id, return the inclusive taxonomic subtree descended
from the specified taxon.
}
\details{
If the output of this function is exported to a file, the only
possible value for the \code{output_format} argument is
\dQuote{\code{newick}}. If the file provided already exists, it
will be silently overwritten.
}
\examples{
\dontrun{
req <- taxonomy_subtree(ott_id=515698)
plot(taxonomy_subtree(ott_id=515698, output_format="phylo"))
}
}

