\name{[<-.msa}
\alias{[<-.msa}
\title{Replace subsets of an alignment}
\usage{
  \method{[}{msa}(x, rows, cols) <- value
}
\arguments{
  \item{x}{An object of type \code{msa}}

  \item{rows}{A numeric vector of sequence indices,
  character vector (containing sequence names), or logical
  vector.  If logical vector, it will be recycled as
  necessary to the length of \code{nrow.msa(x)}. If not
  provided, all rows are selected.}

  \item{cols}{A numeric vector of alignment columns, or a
  logical vector.  If logical vector it will be recycled to
  the same length as \code{ncol.msa(x)}.  Note that these
  are coordinates with respect to the entire alignment.
  x$idx.offset is ignored here.  If cols is not provided,
  all columns are selected.}

  \item{value}{The value to replace in the indicated
  rows/columns.  Should be a character representing a base
  (ie, "A", "C", "G", "T", "N", "-"). Can be a single value
  or a vector of values which match number of selected
  cells.  This value will be recycled to the necessary
  length, and an error produced if the necessary length is
  not an even multiple of \code{length(value)}.  Can also
  give a single character string, in which case it will be
  expanded into a vector using \code{strsplit}.}
}
\value{
  An object of type \code{msa} with the chosen rows/columns
  replaced by value.
}
\description{
  Replace subsets of an alignment
}
\note{
  If \code{x} is stored as a pointer, x will be changed to
  the return value.
}
\examples{
m <- msa(seqs=c("ACGTAT", "AGGTAA", "AGGTAG"),
         names=c("human", "mouse", "rat"))
m[1:2,4:6] <- "G"
m[1,] <- "A"
m[,4:5] <- "-"
m["rat",] <- "ABCDEF"
}
\author{
  Melissa J. Hubisz
}

