% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msa.R
\name{offset.msa}
\alias{offset.msa}
\title{MSA Index Offset}
\usage{
offset.msa(x)
}
\arguments{
\item{x}{an MSA object}
}
\value{
The difference between the first position in an alignment
from the beginning of a chromosome.
}
\description{
Returns the offset of the first position in an alignment from
some reference sequence.
}
\examples{
m <- msa(seqs=c("A--ACGTAT", "AG-AGGTAA", "AGGAGGTAG"),
         names=c("human", "mouse", "rat"))
offset.msa(m)
m <- msa(seqs=c("A--ACGTAT", "AG-AGGTAA", "AGGAGGTAG"),
         names=c("human", "mouse", "rat"), offset=500000)
offset.msa(m)
}
\author{
Melissa J. Hubisz and Adam Siepel
}
\keyword{msa}

