% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgc.R
\name{bgc.nucleotide.tests}
\alias{bgc.nucleotide.tests}
\title{Do maximum likelihood analysis for gBGC and selection using nucleotide model}
\usage{
bgc.nucleotide.tests(align, neutralMod, branch, sel.limits = c(-200, 200),
  bgc.limits = c(0, 200))
}
\arguments{
\item{align}{A nucleotide alignment of type \code{msa}}

\item{neutralMod}{A model of neutral evolution of type \code{tm}.  Should be a nucleotide (4x4) model.}

\item{branch}{A character string giving the name of a branch from neutralMod$tree
where lineage-specific selection/gBGC}

\item{sel.limits}{Numeric vector of length 2 giving lower and upper limits for
selection parameter.}

\item{bgc.limits}{Numeric vector of length 2 giving lower and upper limits
for gBGC parameter B}
}
\value{
A data.frame with four rows.  Each row represents one of the models "null", "sel",
"bgc", and "sel+bgc".  All models have a global selection coefficient; the sel and sel+bgc models have
a lineage-specific selection coefficient as well, and the bgc and sel+bgc models have a lineage-specific
gBGC parameter.  The likelihoods and parameter estimates for each model are returned in the data frame.
}
\description{
Do maximum likelihood analysis for gBGC and selection using nucleotide model
}
\author{
Melissa J. Hubisz
}

