% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query_config}
\alias{query_config}
\title{Query configuration tables}
\usage{
query_config(db)
}
\arguments{
\item{db}{PLEXOS database object}
}
\description{
Get information from the \code{config} table, which includes: PLEXOS version, solution
date and time, machine and location of PLEXOS input database, model description and user
name. Additionally, it stores the version of rplexos used to process the PLEXOS database.
}
\examples{
# Process the folder with the solution file provided by rplexos
location <- location_solution_rplexos()
process_folder(location)

# Query data
db <- plexos_open(location)
query_config(db)

}
\seealso{
\code{\link{plexos_open}} to create the PLEXOS database object

Other special.queries: \code{\link{query_class}},
  \code{\link{query_log}}, \code{\link{query_phase}},
  \code{\link{query_property}}, \code{\link{query_sql}},
  \code{\link{query_time}}
}

