% ---------------------------------------------------------------
% File: /rplotengine/man/rplotengine.Rd
% Una vez instalado el paquete se puede acceder con:
%    > library(rplotengine)
%    > ?rplotengine
% Tambien se puede generar un PDF con:
%    R CMD Rd2pdf rplotengine
% ---------------------------------------------------------------

% Nombre, alias, titulo
\name{rplotengine}
\alias{rplotengine}
\title{R as a plotting engine}

% Descripcion (+ archivo DESCRIPTION)
\description{
   Generate a set of graphs as defined in the file specified.
%\code{save}.
}

% Uso
\usage{
   rplotengine (args_file = "mygraph.arg")
}

% Argumentos
\arguments{
   \item{args_file}{A character string giving the name of the text file containing the parameters for the graph to be plotted. The format of such input file is described in detail below.}
}

% Descripcion detallada
\details{

The \strong{input file} name passed to \pkg{rplotengine} is a plain text file with a list of pairs \code{parameter=value}, one-per-line. 
The meaning of each parameter is explained below:

%\tabular{ll}{
%	Argument     \tab Description \cr
%	Argument     \tab Description
%}

% The % characters must be preceded by \
\describe{
\item{title       }{Main title that can be shown in the graph. It is required to specify \code{show_titles=1}; otherwise the value will be ignored.}
\item{subtitle    }{Subtitle that can be shown in the graph. It is required to specify \code{show_titles=1}; otherwise the value will be ignored.}
\item{x_axis_title}{Title for the X-axis.}
\item{y_axis_title}{Title for the Y-axis.}
\item{col_x_values}{Column number of the values for the X-axis within the input data file (starting from 1).}
\item{col_y_values}{List with the columns number within the input data file corresponding to the series to be plotted. In case of using confidence intervals, each column within the input data file should be followed by another column containing its correspondig confidence interval values, but that column is not specified here, and this is why a tipical value for this argument is something like: 2,4,6,8 (being 3,5,7,9 the corresponding columns for the confidence intervals).}
\item{series_names}{Name for the series to be plotted as should be shown in the legend. The number of names specified should match with the number of columns speficied in the argument col_y_values. In case of showing an overall serie (argumento total_serie greater than 0), an additional name for it should be specified too.}
\item{x_factor    }{Value which the X-axis values will be multiplied by (usually 1).}
\item{y_factor    }{Value which the Y-axis values will be multiplied by (usually 1).}
\item{total_serie }{Value ranged from 0 to 4, to indicate if an additional summary serie should be shown. The values mean: 0-none; 1-sum of all the series; 2-average of all the series; 3-constant value (specified by \code{total_value}); 4-proportional to the x value (proportion specified by \code{total_value}). In case of a total serie be shown (argument total_serie greater than 0), an additional name need to be specified in the list of names (argumento series_names).}
\item{total_value }{Value used for the argument \code{total_serie} in certain cases (3 and 4); otherwise, it is ignored.}
\item{x_min       }{Minimum value for the X-axis (usually 0).}
\item{x_max       }{Maximum value for the X-axis (usually -1). It is recommended to start with the -1 value, in order to the graph be shown automatically adjusted.}
\item{y_min       }{Minimum value for the Y-axis (usually 0).}
\item{y_max       }{Maximum value for the Y-axis (usually -1). It is recommended to start with the -1 value, in order to the graph be shown automatically adjusted.}
\item{y_log       }{Value 0/1 to indicate if the Y-axis should be shown in logarithm scale (usually 0).}
\item{show_titles          }{Value 0/1 to indicate if title and subtitle are shown.}
\item{show_grid            }{Value 0/1 to indicate if a grid are shown in the background.}
\item{show_hotspots        }{Value 0/1 to indicate if points are shown on each value over the lines plotted.}
\item{show_confint         }{Value 0/1 to indicate if confidence interval are shown.}
\item{confint_as_percentage}{Value 0/1 to indicate if the values for the confidence interval within the input data file are expressed as absolute values (0) or as a \% value (1, the margin need to be calculated).}
\item{text_size_title      }{Font size for the title. The value specified will be a proportion to the normal text (1.0): for a greater font size specify values > 1.0; for smaller font size specify values < 1.0.}
\item{text_size_subtitle   }{Font size for the subtitle. The value specified will be a proportion to the normal text (1.0), as explained before.}
\item{text_size_axis_ticks }{Font size for the X-axis and Y-axis numbers. The value specified will be a proportion to the normal text (1.0), as explained before.}
\item{text_size_axis_titles}{Font size for the X-axis and Y-axis titles. The value specified will be a proportion to the normal text (1.0), as explained before.}
\item{text_size_legend     }{Font size for the series names in the legend. The value specified will be a proportion to the normal text (1.0), as explained before.}
\item{pos_legend           }{Place for the legend in the graph, within a 3x3 grid with cells numbered from 1 to 9: 1-top left corner, 2-top middle; 3-top right corner; ... ; 9-bottom right corner. Specify a 0 value if a legend is not required.}
\item{graph_type           }{Type of graph to generate (0:lines; 1:stacked bars).}
\item{width_factor         }{Graph width. The value specified will be a proportion to the normal size (1.0): for a greater font size specify values > 1.0; for smaller font size specify values < 1.0.}
\item{height_factor        }{Graph height. The value specified will be a proportion to the normal size (1.0): for a greater font size specify values > 1.0; for smaller font size specify values < 1.0.}
\item{data_filename        }{Path and name for the input data file. Path may be absolute or relative to the current directory.}
\item{graph_filename       }{Path and name for the graphs to be generated (without suffix). Path may be absolute or relative to the current directory.}
\item{graph_fileext_seq    }{List of suffixes for each output format to generate. For example: png,eps. The final graph file names generated will be the specified with \code{graph_filename} joined to each of these suffixes.}
}

The following is an \strong{example of input file} called \file{mygraph.arg}.

% The % characters must be preceded by \
\preformatted{
# -------------------------------------------------------
# File: mygraph.arg
# -------------------------------------------------------
title=Titulo
subtitle=Subtitulo
x_axis_title=Total offered traffic per AC (Mbit/s)
y_axis_title=Achieved throughput ratio
col_x_values=1
col_y_values=2,4,6,8
series_names=Serie 1,Serie 2,Serie 3,Serie 4,Total
x_factor=1
y_factor=1
total_serie=4
total_value=250.0
x_min=-1
x_max=-1
y_min=-1
y_max=-1
y_log=0
show_titles=0
show_grid=1
show_hotspots=1
show_confint=1
confint_as_percentage=0
text_size_title=1.0
text_size_subtitle=1.0
text_size_axis_ticks=0.8
text_size_axis_titles=0.8
text_size_legend=1
pos_legend=1
graph_type=0
width_factor=1.0
height_factor=1.0
data_filename=./data/mydata.txt
graph_filename=./graphs/mygraph
graph_fileext_seq=png,eps
}

In the previous file, a data file called \file{./data/mydata.txt} is specified with the \code{data_filename} parameter. The following is an \strong{example of input data file}, including columns for the confidence intervals por each statistic.

% The % characters must be preceded by \
\preformatted{
x  Stat1       95\%CI  Stat2       95\%CI   Stat3       95\%CI   Stat4       95\%CI
1  2.70214E+06 121023 1.94245E+06 76146.9 1.1396E+06  72200.2 1.14344E+06 60750.6
2  1.9207E+06  189865 1.58829E+06 80444.8 1.04647E+06 60387   982434      80031.8
3  2.33849E+06 120934 1.85431E+06 116278  1.14719E+06 76487.7 1.35766E+06 84200.6
}

As we can see, column #1 is the X-axis values, as set with the \code{col_x_values}. On the other hand, four series are going to be shown, corresponding to the columns specified by \code{col_y_values}: 2,4,6,8. The rest of columns (3,5,7,9) are the confidence intervals computed for each serie, respectively.

As a result of executing the command \code{rplotengine("mygraph.arg")}, two graphs files will be generated: \file{mygraph.png} and \file{mygraph.eps}.

}

% Valor retornado por la funcion
\value{ 
   This function return a logical value indicating if the operation has succeeded (TRUE) or not (FALSE).
}

% Ver tambien
%\seealso{
%\code{\link{save}}.
%}

% Palabra clave
%\keyword{file}

% Autor
\author{
   P. Pablo Garrido Abenza (\email{pgarrido@umh.es}) \cr
   \href{http://www.umh.es}{Miguel Hernandez University} (Elche, Spain) \cr
   \href{http://atc.umh.es/pgarrido/}{GatCom Group}
   %\url{http://atc.umh.es/pgarrido/}
}

% Ejemplos de uso
\examples{
## Generate the graphs as defined in the 'mygraph.arg' file.
rplotengine ()
## Generate the graphs as defined in the 'mygraph.arg' file.
rplotengine ("mygraph.arg")
}


