% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{agemodel.it}
\alias{agemodel.it}
\title{Extract one age-model iteration}
\usage{
agemodel.it(it, set = get("info"), BCAD = set$BCAD)
}
\arguments{
\item{it}{The MCMC iteration of which the age-model should be calculated.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}
}
\value{
A variable with two columns - depth and the age-depth model of a single iteration.
}
\description{
For one MCMC iteration (it), extract the corresponding age-depth model.
}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474.
\url{https://projecteuclid.org/euclid.ba/1339616472}
}
\seealso{
\url{http://www.qub.ac.uk/chrono/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
