% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpm.model.matrix.R
\name{rpm.model.matrix}
\alias{rpm.model.matrix}
\title{Creates a model matrix to estimate the parameters of a Revealed Preference Matchings Model}
\usage{
rpm.model.matrix(model.terms, Xall, Zall, intercept = TRUE)
}
\arguments{
\item{model.terms}{For the details on the possible \code{<model terms>}, see
\code{\link{rpm-terms}}. This includes the 
covariates used to construct the model matrix.
They are used in conjunction with the model terms.}

\item{Xall}{the unique types of women}

\item{Zall}{the unique types of men}

\item{intercept}{logical; If TRUE, the default, an intercept term is prepended.}
}
\value{
A list consists of the following elements:
\item{X}{the model matrix for women.}
\item{Z}{the model matrix for men.}
\item{Xnames}{the names of the covariates for women.} 
\item{Znames}{the names of the covariates for men.}
}
\description{
\code{\link{rpm.model.matrix}} assumes a bipartite network (i.e. two-sided matching market)
It creates a model matrix according to the formula passed in.
See \code{\link{rpm-terms}} for a description of the possible terms.
}
\examples{
# nothing yet
}
\references{
Goyal, Handcock, Jackson. Rendall and Yeung (2023).
\emph{A Practical Revealed Preference Model for Separating Preferences and Availability Effects in Marriage Formation}
\emph{Journal of the Royal Statistical Society}, A. \doi{10.1093/jrsssa/qnad031} 
Menzel, K. (2015).
\emph{Large Matching Markets as Two-Sided Demand Systems}
Econometrica, Vol. 83, No. 3 (May, 2015), 897-941.
}
\seealso{
rpm
}
\keyword{models}
